package com.ds.vfs.adapter;

import java.io.InputStream;
import java.util.List;

import com.ds.common.md5.MD5InputStream;
import com.ds.common.md5.MD5OutputStream;

public interface FileAdapter {

    public String getRootPath();

    public String createFolderPath();

    public void mkdirs(String vfsPath);

    public void delete(String vfsPath);

    public boolean exists(String vfsPath);

    public boolean testConnection(String vfsPath);

    public long write(String vfsPath, MD5InputStream in);

    public long write(String vfsPath, InputStream in);

    public MD5InputStream getMD5InputStream(String vfsPath);

    public InputStream getInputStream(String vfsPath);

    public Integer writeLine(String vfsPath, String str);

    public Long  getLength(String vfsPath);

    public List<String> readLine(String vfsPath, List<Integer> lineNums);

    public String getMD5Hash(String vfsPath);

    public MD5OutputStream getOutputStream(String vfsPath);

}
