package com.ds.vfs;

import com.ds.common.JDSException;
import com.ds.common.md5.MD5InputStream;
import com.ds.enums.db.MethodChinaName;
import com.ds.web.annotation.Entity;
import com.ds.web.annotation.Pid;

import java.util.List;

/**
 * 文件实体
 */
@Entity
public interface FileObject extends java.io.Serializable {
    @MethodChinaName(cname = "取得文件标识")
    @Pid
    public String getID();

    @MethodChinaName(cname = "文件标识")
    public void setID(String id);

    @MethodChinaName(cname = "取得文件名称")
    public String getName();

    @MethodChinaName(cname = "文件名称")
    public void setName(String name);

    @MethodChinaName(cname = "跟目录地址")
    public String getRootPath();

    @MethodChinaName(cname = "跟目录地址")
    public void setRootPath(String path);

    @MethodChinaName(cname = "文件读取适配器")
    public String getAdapter();

    @MethodChinaName(cname = "文件读取适配器")
    public void setAdapter(String adapter);

    @MethodChinaName(cname = "取得文件大小")
    public Long getLength();

    @MethodChinaName(cname = "文件大小")
    public void setLength(Long length);


    @MethodChinaName(cname = "取得文件hash")
    public String getHash();

    @MethodChinaName(cname = "文件hash")
    public void setHash(String hash);

    @MethodChinaName(cname = "取得文件物理路径")
    public String getPath();

    @MethodChinaName(cname = "文件物理路径")
    public void setPath(String path);

    @MethodChinaName(cname = "取得创建时间")
    public Long getCreateTime();


    @MethodChinaName(cname = "取得创建时间")
    public void setCreateTime(Long createTime);

    @MethodChinaName(cname = "下载片段流")
    public MD5InputStream downLoad() throws JDSException;

    @MethodChinaName(cname = "追加片段流")
    public Integer writeLine(String str) throws JDSException;

    @MethodChinaName(cname = "获取指定行数据")
    public List<String> readLine(List<Integer> lineNums) throws JDSException;

}
