package com.ds.service.org;

import com.ds.common.expression.ParseException;
import com.ds.common.expression.function.AbstractFunction;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.server.JDSClientService;
import com.ds.server.OrgManagerFactory;

@EsbBeanAnnotation(expressionArr = "currPerson(JDSC())", id = "currPerson", desc = "获取当前人")
public class GetCurrPerson extends AbstractFunction {


    public Person perform(JDSClientService client) throws ParseException {
        Person person = null;
        try {
            person = OrgManagerFactory.getOrgManager(client.getConfigCode()).getPersonByID(client.getConnectInfo().getUserID());
        } catch (PersonNotFoundException e) {
            throw new ParseException(e);
        }
        if (person == null) {
            throw new ParseException("session is null");
        }

        return person;
    }
}