package com.ds.server;

import com.ds.client.JDSSessionFactory;
import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSContext;
import com.ds.context.RunableActionContextImpl;
import com.ds.engine.ConnectionHandle;
import com.ds.server.eumus.ConfigCode;

public class JDSLocalServer {
    static JDSLocalServer instance;

    public static final String THREAD_LOCK = "Thread Lock";

    private static final Log logger = LogFactory.getLog(
            JDSConstants.CONFIG_KEY, JDSLocalServer.class);


    /**
     * 取得JDSServer服务器的单例实现
     *
     * @return
     * @throws JDSException
     */
    public static JDSLocalServer getInstance() throws JDSException {
        if (instance == null) {
            synchronized (THREAD_LOCK) {
                if (instance == null) {
                    instance = new JDSLocalServer();
                }
            }
        }

        return instance;
    }


    public void connect(RunableActionContextImpl context)
            throws JDSException {
        try {


            JDSLocalServer.getInstance().getClient(context);


            JDSClientService client = this.getClient(context);

            String sessionId = (String) context.getSessionId();
            if (sessionId != null) {
                if (client != null) {
                    ConnectionHandle handle = client.getConnectionHandle();
                    handle.connect(context);
                }
            } else {
                throw new JDSException("sessionId is  null,  place login frist!");

            }

        } catch (JDSException e1) {
            logger.info(e1);
            throw new JDSException(
                    "sessionId is invalidate  url:[" + "] place login again!");


        }

    }

    public JDSClientService getClient(JDSContext context) throws JDSException {

        JDSSessionFactory factory = new JDSSessionFactory(context);
        String sessionId = (String) context.getSessionId();

        if (sessionId == null) {
            sessionId = (String) context.getParams(context.JSESSIONID);
        }
        if (sessionId != null) {
            context.getContext().put(context.JSESSIONID, sessionId);
        }

        String systemCode = JDSServer.getInstance().getCurrServerBean().getId();

        ConfigCode configCode = JDSServer.getInstance().getCurrServerBean().getConfigCode();

        context.getContext().put(context.SYSCODE, systemCode);

        JDSClientService appClient = null;
        try {
            appClient = factory.getJDSClientBySessionId(sessionId, configCode);

        } catch (JDSException e) {
            logger.error("sessionId is invalidate sessionId=[" + sessionId + "] ieee=[+" + context.getParams("ieee") + "] place login again!");
        }

        if (appClient != null) {
            appClient.setContext(context);
        }

        return appClient;
    }


}
