
package com.ds.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.ds.common.JDSConstants;
import com.ds.common.cache.Cache;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.engine.ConnectInfo;
import com.ds.engine.JDSSessionHandle;
import com.ds.engine.event.Listener;

public class ClearSessionCheckTask implements Runnable {

    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, ClearSessionCheckTask.class);

    private long expireTime;

    private String systemCode;

    public ClearSessionCheckTask(long expireTime) {
	this.expireTime = expireTime;
    }

    public ClearSessionCheckTask(long expireTime, String systemCode) {
	this.expireTime = expireTime;
	this.systemCode = systemCode;

    }

    public void run() {
	try {
	    if (JDSServer.getInstance().started()) {
		// synchronized (JDSServer.THREAD_LOCK) {

		List<JDSSessionHandle> invalidSessionList = new ArrayList<JDSSessionHandle>();
		long currentTime = System.currentTimeMillis();
		// 验证Session是否有需要进行过期处理
		Cache cache = JDSServer.getInstance().getSessionHandleCache();
		Set<String> ites = JDSServer.getInstance().getSessionHandleCache().keySet();

		Integer size = ites.size();
		Thread.currentThread().setName("ClearSessionCheckTask size" + ites.size());
		for (String sessionId : ites) {
		    Object obj = cache.get(sessionId);

		    if (obj != null && (obj instanceof JDSSessionHandle)) {
			ConnectInfo connectInfo = JDSServer.getInstance().getConnectInfo((JDSSessionHandle) obj);
			if (connectInfo != null && connectInfo.getLoginName() != null && connectInfo.getLoginName().length() == 11) {
			    invalidSessionList.add((JDSSessionHandle) obj);

			}
			String code = JDSServer.getInstance().getSessionhandleSystemCodeCache().get(obj.toString());

			if (code != null) {
			    if (!code.equals("gateway")) {
				// 测试主节点
				JDSServer.getInstance().getSessionhandleSystemCodeCache().put(obj.toString(), "gateway");
			    }

			}

		    }
		    Thread.currentThread().setName("ClearSessionCheckTask size" + size--);

		}

		JDSServer.getInstance().invalidateSession(invalidSessionList);

	    }
	} catch (Exception bpme) {
	    logger.error("Get WorkflowServer instance failed.", bpme);
	}

    }

}
