package com.ds.jds.core.esb.task;

import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.context.MinServerActionContextImpl;
import com.ds.jds.core.esb.EsbUtil;

import java.util.concurrent.Callable;

public class ExcuteExpression<T extends ExcuteObj> implements Callable<T> {

    private final ExcuteObj obj;
    private MinServerActionContextImpl autoruncontext;

    public ExcuteExpression(ExcuteObj obj) {
        JDSContext context = JDSActionContext.getActionContext();
        this.autoruncontext = new MinServerActionContextImpl(context.getHttpRequest());
        autoruncontext.setParamMap(context.getContext());
        this.obj = obj;
        if (context.getSessionId() != null) {
            autoruncontext.setSessionId(context.getSessionId());
            autoruncontext.getSession().put("sessionHandle", context.getSession().get("sessionHandle"));
        }
        autoruncontext.setSessionMap(context.getSession());

    }

    @Override
    public T call() throws Exception {
        JDSActionContext.setContext(autoruncontext);
        Object valueObj = EsbUtil.parExpression(obj.getExpression(), obj.getClazz());
        obj.setObj(valueObj);
        return (T) obj;

    }
}