package com.ds.esb.expression;

import com.ds.client.JDSSessionFactory;
import com.ds.common.JDSException;
import com.ds.common.expression.ParseException;
import com.ds.common.expression.function.AbstractFunction;
import com.ds.common.util.ClassUtility;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.server.JDSClientService;
import com.ds.web.invocation.HttpClientInvocationHandler;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import net.sf.cglib.proxy.Proxy;


public class RemoteClientFunction extends AbstractFunction {

    private final String clazzName;
    private final String serverUrl;
    private JDSClientService clientService;

    public RemoteClientFunction(JDSClientService clientService, String clazzName, String serverUrl) {
        numberOfParameters = 3;
        this.clientService = clientService;
        this.clazzName = clazzName;
        this.serverUrl = serverUrl;
    }


    public Object perform() throws ParseException {
        ClassPool pool = ClassPool.getDefault();
        Class interfaces = null;
        CtClass ct = null;

        try {
            ct = pool.getCtClass(clazzName);
            String iclassName = ct.getInterfaces()[0].getName();
            interfaces = ClassUtility.loadClass(iclassName);
        } catch (NotFoundException e) {
            e.printStackTrace();
            throw new ParseException(e.getMessage());
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new ParseException(e.getMessage());
        }


        HttpClientInvocationHandler handler = null;
        try {
            handler = new HttpClientInvocationHandler(clientService, ct, serverUrl);
        } catch (JDSException e) {
            e.printStackTrace();
            throw new ParseException(e.getMessage());
        }
        Object service = Proxy.newProxyInstance(interfaces.getClassLoader(), new Class[]{interfaces}, handler);
        return service;

    }


}
