/**
 * $RCSfile: ServiceConfig.java,v $
 * $Revision: 1.2 $
 * $Date: 2016/04/17 11:40:18 $
 * <p>
 * Copyright (C) 2003 spk, Inc. All rights reserved.
 * <p>
 * This software is the proprietary information of spk, Inc.
 * Use is subject to license terms.
 */
package com.ds.esb.config.xml;

import com.ds.common.JDSException;
import com.ds.common.property.ConfigFactory;
import com.ds.common.property.XMLProperties;
import com.ds.config.JDSConfig;
import com.ds.config.JDSConfig.Config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ServiceConfig {

    private String fileName = "expressiontemplet_config.xml";

    private static final Map<String, XMLProperties> propertiesMap = new HashMap<String, XMLProperties>();
    private static final Map<String, ServiceConfig> serverConfigMap = new HashMap<String, ServiceConfig>();
    private XMLProperties propertie;

    public static void clear() {
        propertiesMap.clear();
        serverConfigMap.clear();
    }

    public static ServiceConfig getServiceConfig(String configFileName) throws JDSException {
        ServiceConfig serviceConfig = serverConfigMap.get(configFileName);
        if (serviceConfig == null) {
            serviceConfig = new ServiceConfig(configFileName);
            serverConfigMap.put(configFileName, serviceConfig);
        }
        return serviceConfig;
    }

    XMLProperties getProperties() throws JDSException

    {
        this.propertie = propertiesMap.get(fileName);
        if (propertie == null) {
            File engineConfigFile = new File(Config.configPath(), fileName);

            if (!engineConfigFile.exists()) {
                engineConfigFile = new File(Config.publicConfigPath(), fileName);
            }
            if (!engineConfigFile.exists()) {
                String path = JDSConfig.getAbsolutePath(File.separator);
                if (path == null) {
                    path = "JDSHome" + File.separator + "config" + File.separator;
                }
                engineConfigFile = new File(path + fileName);
            }


            if (engineConfigFile.exists()) {
                propertie = ConfigFactory.getXML(engineConfigFile.getAbsolutePath());
                propertiesMap.put(fileName, propertie);
            } else {
                throw new JDSException("System error:   " + engineConfigFile.getAbsolutePath() + " not  exists! '" + JDSException.LOADAPPLICATIONCONFIGERROR);

            }

        }

        return propertie;
    }

    ServiceConfig(String fileName) throws JDSException {
        if (fileName != null) {
            this.fileName = fileName;
        }
        this.getProperties();
    }


    public String getValue(String name) {
        return propertie.getProperty(name);
    }

    public String[] getValues(String name) {
        return propertie.getProperties(name);

    }


    String getFileName() {
        return fileName;
    }

    void setFileName(String fileName) {
        this.fileName = fileName;
    }

//
}
