package com.ds.esb.config.invocation;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.Constants;
import com.ds.esb.util.Debug;
import org.mvel2.ast.ASTNode;
import org.mvel2.integration.Interceptor;
import org.mvel2.integration.VariableResolverFactory;

public class DebugInterceptor implements Interceptor{
	private static final Log logger = LogFactory.getLog(
			Constants.CONFIG_KEY, DebugInterceptor.class);
		
	 Debug debug=new Debug();
     public int doBefore(ASTNode node, VariableResolverFactory factory) {
     	logger.info("************************************************");
 		logger.info("----- expression "+node.getName()+" par start");
     	debug.setName(node.getName());
     	debug.setStartTime(System.currentTimeMillis());
         return 0;
     }

     public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
     	debug.setEndTime(System.currentTimeMillis());
 		logger.info("************************************************");
 		long timeLoadOrg = System.currentTimeMillis() - debug.getStartTime();
 		logger.info("----- par "+debug.getName()+" in " + timeLoadOrg
 				/ Constants.SECOND + "s:" + timeLoadOrg % Constants.SECOND
 				+ " -----");
 		logger.info("************************************************");
     	
         return 0;
     }

}
