package com.ds.esb.config.invocation;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.esb.util.ESBConstants;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

import java.io.Serializable;

public abstract class AbstractInvocationHandler implements MethodInterceptor,
		Serializable {
	
	private static final long serialVersionUID = 1L;

	protected transient static final Log log = LogFactory.getLog(
			ESBConstants.CONFIG_KEY, AbstractInvocationHandler.class);

	private Enhancer enhancer = new Enhancer();

	// 返回DAO的子类
	public Object getBean(Class clz) {
		enhancer.setSuperclass(clz);
		
		enhancer.setCallback(this);
		Object object = null;
		try {
			object = enhancer.create();
		} catch (Exception e) {
			try {
				object = clz.newInstance();
			} catch (Exception e1) {
				log.error(clz + " new err");
			}
		}

		return object;
	}
	
//	 返回DAO的子类
	public Object getBean(Class clz,Class[] argumentTypes,Object[]  arguments) {
		enhancer.setSuperclass(clz);
		
		enhancer.setCallback(this);
		Object object = null;
		try {
			if (argumentTypes.length>0){
				object = enhancer.create(argumentTypes, arguments);
			}else{
				object = enhancer.create();
			}
			
		} catch (Exception e) {
			try {
				object = clz.newInstance();
			} catch (Exception e1) {
				log.error(clz + " new err");
			}
		}

		return object;
	}

	

}

