package com.ds.esb.config.annotation;
/**
 * time 06-01-01
 *
 * @author wenzhang
 */

import com.ds.command.JDSCommand;
import com.ds.common.expression.function.Function;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.Constants;
import com.ds.common.util.JarLoader;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSConfig;
import com.ds.esb.config.ClassMappingAnnotation;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.JDSBusException;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esb.config.manager.ServiceConfigManager;
import javassist.ClassPool;
import javassist.NotFoundException;
import net.sf.cglib.beans.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractAnnotationtExpressionTempManager implements ServiceConfigManager {
    private static final Log logger = LogFactory.getLog(Constants.CONFIG_KEY, AbstractAnnotationtExpressionTempManager.class);
    private static String OS = System.getProperty("os.name").toLowerCase();

    private static final Logger log = LoggerFactory.getLogger(AbstractAnnotationtExpressionTempManager.class);
    public Set<Class<?>> classList = new HashSet<>();


    private static Map<Class, String> pathMap = new HashMap<Class, String>();

    public Map<String, ServiceBean> nameMap = new HashMap<String, ServiceBean>();

    public Map<String, ServiceBean> idMap = new HashMap<String, ServiceBean>();

    public List<ServiceBean> serviceBeanList = new ArrayList<ServiceBean>();

    public EsbBean esbBean;

    public EsbBean getEsbBean() {
        return esbBean;
    }

    public void setEsbBean(EsbBean esbBean) {
        this.esbBean = esbBean;
    }

    public List<ServiceBean> loadAllService() {
        return serviceBeanList;
    }

    public Map<String, ServiceBean> findServiceConfigMapById() {
        return idMap;
    }

    public Map<String, ServiceBean> findServiceConfigMapByName() {
        return nameMap;
    }

    public ServiceBean getServiceConfigById(String id) {

        return idMap.get(id);
    }

    public ServiceBean getServiceConfigByName(String name) {
        return nameMap.get(name);
    }

    /**
     * 填充BEAN实体
     *
     * @param clazz
     */
    public void fillBean(Class clazz, Map valueMap) {
        if (pathMap.containsKey(clazz)) {
            String path = pathMap.get(clazz);
            valueMap.put("path", path);
            if (path.endsWith("class")) {
                File file = new File(pathMap.get(clazz));
                valueMap.put("creatTime", file.lastModified());
            }
        }
        try {


            Annotation[] annotations = clazz.getAnnotations();
            for (int j = 0; j < annotations.length; j++) {
                Annotation annotation = annotations[j];
                Class enumType = annotation.annotationType();
                try {
                    ClassMappingAnnotation classMappingAnnotation = annotation.annotationType().getAnnotation(ClassMappingAnnotation.class);


                    if (classMappingAnnotation != null && ServiceBean.class.isAssignableFrom(classMappingAnnotation.clazz())) {
                        for (int k = 0; k < enumType.getDeclaredMethods().length; k++) {
                            Method method = enumType.getDeclaredMethods()[k];
                            valueMap.put(method.getName(), method.invoke(annotation, null));
                        }
                        ServiceBean bean = (ServiceBean) classMappingAnnotation.clazz().newInstance();

                        BeanMap beanMap = BeanMap.create(bean);
                        beanMap.putAll(valueMap);
                        if (Function.class.isAssignableFrom(clazz)) {
                            Class innerClass = getInnerClass("perform", clazz);
                            beanMap.put("clazz", clazz.getName());
                        } else {
                            if (valueMap.get("clazz") == null || valueMap.get("clazz").equals("")) {
                                beanMap.put("clazz", clazz.getName());
                            }
                            if (valueMap.get("clazz") == null || valueMap.get("clazz").equals("")) {
                                beanMap.put("clazz", clazz.getName());
                            }
                            if (valueMap.get("id") == null || valueMap.get("id").equals("")) {
                                beanMap.put("id", clazz.getSimpleName());
                            }

                        }

                        if (valueMap.get("expressionArr") == null || valueMap.get("expressionArr").equals("")) {
                            beanMap.put("expressionArr", clazz.getSimpleName() + "()");
                        }
                        beanMap.put("mainClass", clazz.getName());
                        String returntype = (String) beanMap.get("expressionArr");
                        if (JDSCommand.class.isAssignableFrom(clazz)) {
                            beanMap.put("flowType", EsbFlowType.command);
                        }
                        if (returntype != null && !returntype.equals("")) {
                            beanMap.put("returntype", returntype.substring(0, returntype.indexOf("(")));
                        }

                        if (this.idMap.containsKey(bean.getId())) {
                            ServiceBean oldBean = idMap.get(bean.getId());
                            if (bean.getVersion() > oldBean.getVersion()) {
                                serviceBeanList.remove(this.idMap.get(bean.getId()));
                                serviceBeanList.add(bean);
                                this.nameMap.put(bean.getName(), bean);
                                this.idMap.put(bean.getId(), bean);
                            } else if (bean.getVersion() == oldBean.getVersion()) {
                                if (!oldBean.getClazz().equals(bean.getClazz())) {
                                    logger.error("load bean err beanid=<<" + oldBean.getId() + ">> def in 2 class " + "[" + oldBean.getClazz() + "," + bean.getClazz() + "]");

                                }
                                serviceBeanList.remove(this.idMap.get(bean.getId()));
                                serviceBeanList.add(bean);
                                this.nameMap.put(bean.getName(), bean);
                                this.idMap.put(bean.getId(), bean);
                            }
                        } else {
                            serviceBeanList.add(bean);
                            this.nameMap.put(bean.getName(), bean);
                            this.idMap.put(bean.getId(), bean);
                        }
                        //EsbUtil.getClassMap().put(clazz, (ExpressionTempBean) bean);
                    }

                } catch (Throwable e) {
                    log.info("Error load  class==" + clazz.getName());
                    e.printStackTrace();
                }

            }
        } catch (Throwable e) {
            log.info("Error load  class==" + clazz.getName());
            e.printStackTrace();
        }

    }


    /***
     * 初始化,一般从 Jar 包读取 Bean
     *
     * @throws JDSBusException
     */
    public Set<Class<?>> init() throws JDSBusException {
        String parma = esbBean.getPath();

        log.info("path====================================:" + parma);
        String[] pathArr = parma.split(";");
        for (int k = 0; k < pathArr.length; k++) {

            String path = pathArr[k];
            try {

                //优先支持正则表达式
                if (path.indexOf(":") > -1) {
                    String[] paths = path.split(":");
                    String pattern = paths[1];
                    String folderPath = this.getRootPath(paths[0]);
                    File file = new File(folderPath);
                    if (!file.exists()) {
                        throw new IOException("file [" + path + "] load error! folderPath=" + folderPath);
                    }

                    if (file.isFile()) {
                        throw new IOException("file [" + path + "] not  folder! ");
                    }
                    log.info(pattern + " load success: start load:" + file.getAbsolutePath());
                    if (Paths.get(folderPath).toFile().isDirectory()) {

                        File[] files = file.listFiles();
                        for (File cfile : files) {
                            Pattern p = Pattern.compile(pattern);
                            Matcher matcher = p.matcher(cfile.getName());
                            if (matcher.find() && cfile.getName().endsWith("jar")) {
                                this.classList.addAll(this.initJar(cfile.getAbsolutePath()));
                                log.info(pattern + " pattern success: start load:" + cfile.getName());
                            }
                        }
                    }
                } else if (path.endsWith(".jar")) {
                    String rootPath = getRootPath(path);
                    this.classList.addAll(this.initJar(rootPath));
                } else {
                    File file = new File(path);
                    if (path.startsWith(File.separator)) {
                        String absolutePath = JDSConfig.getAbsolutePath("", this.getClass());
                        log.info("absolutePath:" + absolutePath);
                        String fileName = absolutePath + StringUtility.replace(path.substring(0, path.length() - 4), File.separator, "/");
                        log.info("realPah:{}", path);
                        file = new File(fileName);
                    } else if (path.equals("*")) {
                        file = new File(JDSConfig.getAbsolutePath("", null));
                    } else if (!path.equals("*") && path.startsWith("*")) {
                        String absolutePath = JDSConfig.getAbsolutePath("", null);
                        log.info("*absolutePath:" + path);
                        String fileName = absolutePath + StringUtility.replace(path.substring(1, path.length()), ".", File.separator);
                        file = new File(fileName);
                    }
                    toFileNames(file);
                }
            } catch (Exception e1) {
                throw new JDSBusException(pathArr[k] + " load Err  context=" + JDSConfig.getAbsolutePath("", this.getClass()), e1);
            }
        }
        fillBean(classList);
        return classList;
    }

    protected abstract void fillBean(Set<Class<?>> classList2);

    /**
     * 给定一个文件路径解析其中的.class和.jar文件
     *
     * @param src
     * @throws ClassNotFoundException
     * @throws IOException
     */
    public void toFileNames(File src) throws IOException {
        File[] chs = src.listFiles();
        for (int i = 0; i < chs.length; i++) {
            if (chs[i].isFile()) {
                String path = chs[i].getPath();
                if (path.endsWith(".class")) {
                    String absolutePath = JDSConfig.getAbsolutePath("", this.getClass());
                    absolutePath = StringUtility.replace(absolutePath, "/", File.separator);
                    absolutePath = StringUtility.replace(absolutePath, "\\", File.separator);

                    if (absolutePath.startsWith(File.separator)) {
                        absolutePath = absolutePath.substring(1, absolutePath.length());
                    }
                    String className = StringUtility.replace(path, absolutePath, "");
                    className = StringUtility.replace(className, File.separator, ".");
                    className = className.substring(0, className.length() - 6);
                    Class clazz;
                    try {
                        clazz = ClassUtility.loadClass(className);
                        this.classList.add(clazz);
                        pathMap.put(clazz, chs[i].getAbsolutePath());
                    } catch (ClassNotFoundException e) {
                        // TODO Auto-generated catch block
                        // e.printStackTrace();
                    }

                } else if (path.endsWith(".jar")) {
                    String rootPath = getRootPath(path);
                    this.initJar(rootPath);
                }
            } else {
                toFileNames(chs[i]);
            }
        }

    }

    private String getRootPath(String path) {
        log.info("originPath=[{}]", path);
        String rootPath = StringUtility.replace(path, "\\", File.separator);
        rootPath = StringUtility.replace(path, "/", File.separator);
        rootPath = StringUtility.replace(rootPath, "\\", File.separator);
        log.info("originPathAfterReplace=[{}]", rootPath);

        if (path.startsWith("JDSHome")) {
            rootPath = StringUtility.replace(path, "JDSHome", JDSConfig.getServerHome());
        } else if (path.startsWith("/") || path.startsWith("\\")) {
            String classPath = "";

            if (JDSConfig.getAbsolutePath("", this.getClass()).indexOf("WEB-INF/") > -1) {
                log.info("[{}]has[WEB-INF]", path);
                classPath = JDSConfig.getAbsolutePath("", this.getClass()).substring(0, JDSConfig.getAbsolutePath("", this.getClass()).indexOf("WEB-INF/"));
            } else if (JDSConfig.getAbsolutePath("", this.getClass()).indexOf("bin/") > -1) {

                classPath = JDSConfig.getAbsolutePath("", this.getClass()).substring(0, JDSConfig.getAbsolutePath("", this.getClass()).indexOf("bin/"));
            } else {
                classPath = JDSConfig.getAbsolutePath("", this.getClass());
            }


            classPath = StringUtility.replace(classPath, "/", File.separator);
            classPath = StringUtility.replace(classPath, "\\", File.separator);


            if (rootPath.startsWith(File.separator)) {
                rootPath = rootPath.substring(1, rootPath.length());
            }
            rootPath = classPath + rootPath;
            log.info("[{}]OS", OS);
            if (OS.indexOf("window") > -1) {
                if (rootPath.startsWith(File.separator)) {
                    rootPath = rootPath.substring(1, rootPath.length());
                }
            }


        }

        return rootPath;
    }

    /**
     * 解析JAR文件
     *
     * @param path 例如: / xxx/ xxx.jar
     * @return
     * @throws IOException
     */
    private Set<Class<?>> initJar(String path) throws IOException {

        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("file [" + path + "] load error! ");
        }

        JarLoader loader = new JarLoader(file, this.getClass().getClassLoader());
        ClassPool pool = ClassPool.getDefault();
        try {
            pool.appendClassPath(file.getPath());
        } catch (NotFoundException e) {
            e.printStackTrace();
        }
        return loader.getAllClassByPackage();
    }

    public static Class getInnerClass(String fieldName, Class listClass) {
        Class innerClazz = null;

        try {
            Class clazz = null;
            String className = listClass.getName();
            if (className.indexOf("$$") > -1) {
                className = className.substring(0, className.indexOf("$$"));
            }
            clazz = ClassUtility.loadClass(className);

            innerClazz = findClassByKey(clazz, fieldName);
            if (innerClazz == null) {
                String getmethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                innerClazz = findClassByKey(clazz, getmethodName);
            }

        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return innerClazz;
    }

    private static Class findClassByKey(Class clazz, String methodName) {

        Class classzz = null;
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            if (method.getName().equals(methodName)) {
                if (!List.class.isAssignableFrom(method.getReturnType())) {
                    classzz = method.getReturnType();
                } else {
                    try {
                        Type type = method.getGenericReturnType();
                        classzz = (Class) ((ParameterizedType) type).getActualTypeArguments()[0];
                    } catch (SecurityException e) {
                        log.error("SecurityException fieldName=" + methodName + "  in class" + clazz.getName());

                    }
                }
            }
        }
        return classzz;
    }

}