package com.ds.enums.db;

import com.ds.enums.CustomBean;
import com.ds.web.annotation.AnnotationType;
import com.ds.web.annotation.Repository;
import com.ds.web.util.AnnotationUtil;

@AnnotationType(clazz = Repository.class)
public class RepositoryBean implements CustomBean {
    String repositoryId;

    String imageClass;

    Class entityClass;

    Class sourceClass;

    public RepositoryBean() {

    }


    public String getRepositoryId() {
        return repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getImageClass() {
        return imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    public Class getEntityClass() {
        return entityClass;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public Class getSourceClass() {
        return sourceClass;
    }

    public void setSourceClass(Class sourceClass) {
        this.sourceClass = sourceClass;
    }

    public RepositoryBean(Repository annotation) {
        fillData(annotation);
    }

    public RepositoryBean fillData(Repository annotation) {
        return AnnotationUtil.fillBean(annotation, this);
    }

    public String toAnnotationStr() {
        return AnnotationUtil.toAnnotationStr(this);
    }

}
