package com.ds.enums.db;

import com.alibaba.fastjson.annotation.JSONField;
import com.ds.common.util.ClassUtility;
import com.ds.enums.CustomBean;
import com.ds.web.annotation.AnnotationType;
import com.ds.web.annotation.Entity;
import com.ds.web.annotation.Repository;
import com.ds.web.util.AnnotationUtil;

@AnnotationType(clazz = Entity.class)
public class EntityBean implements CustomBean {
    String repositoryId;

    String imageClass;
    @JSONField(serialize = false)
    Class entityClass;

    String entityClassName;

    @JSONField(serialize = false)
    Class sourceClass;

    String sourceClassName;

    public EntityBean() {

    }

    public String getEntityClassName() {
        return entityClassName;
    }

    public void setEntityClassName(String entityClassName) {
        this.entityClassName = entityClassName;
    }

    public String getSourceClassName() {
        return sourceClassName;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public String getRepositoryId() {
        return repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getImageClass() {
        return imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    public Class getEntityClass() {
        if (entityClass == null && entityClassName != null && !entityClassName.equals("")) {
            try {
                entityClass = ClassUtility.loadClass(entityClassName);
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return entityClass;
    }

    public void setEntityClass(Class entityClass) {
        if (entityClass != null) {
            entityClassName = entityClass.getName();
        }
        this.entityClass = entityClass;
    }

    public Class getSourceClass() {

        if (sourceClass == null && sourceClassName != null && !sourceClassName.equals("")) {
            try {
                sourceClass = ClassUtility.loadClass(sourceClassName);
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }

        return sourceClass;
    }

    public void setSourceClass(Class sourceClass) {

        if (sourceClass != null) {
            sourceClassName = sourceClass.getName();
        }
        this.sourceClass = sourceClass;
    }

    public EntityBean(Repository annotation) {
        fillData(annotation);
    }

    public EntityBean fillData(Repository annotation) {
        return AnnotationUtil.fillBean(annotation, this);
    }

    public String toAnnotationStr() {
        return AnnotationUtil.toAnnotationStr(this);
    }

}
