package com.ds.engine;

import com.ds.command.JDSCommand;
import com.ds.common.JDSException;
import com.ds.context.JDSContext;
import com.ds.msg.Msg;
import com.ds.server.JDSClientService;

import java.io.Serializable;

public interface ConnectionHandle extends Serializable{

	/**
	 * 获取应用客户端
	 * @return
	 * @throws JDSException
	 */
	public JDSClientService getClient() throws JDSException;
	
	/**
	 * 获取链接用户信息
	 * @return
	 */
	public ConnectInfo getConnectInfo();
	
	/**
	 * 挂接链接
	 * @param context
	 * @throws JDSException
	 */
	public void connect(JDSContext context)throws JDSException;
	
	/**
	 * 是否已连接
	 * @return
	 * @throws JDSException
	 */
	public boolean isconnect()throws JDSException;
	
	/**
	 * 注销
	 * @throws JDSException
	 */
	public void disconnect()throws JDSException;
	
	/**
	 *  接收返回值
	 * @throws JDSException
	 */
	public void receive(String receiveStr)throws JDSException;
	
	/**
	 * 发送消息
	 * @param msgStr
	 * @return
	 * @throws JDSException
	 */
	public boolean send(String msgStr)throws JDSException;
	

	/**
	 * 转发消息
	 * @param msg
	 * @param handle
	 * @return
	 * @throws JDSException
	 */
	public boolean repeatMsg(Msg msg, JDSSessionHandle handle)throws JDSException;
	
	/**
	 * 转发命令
	 * @param command
	 * @param handle
	 * @return
	 * @throws JDSException
	 */
	public boolean repeatCommand(JDSCommand command, JDSSessionHandle handle)throws JDSException;

	/**
	 * 发送消息
	 * @param command
	 * @return
	 * @throws JDSException
	 */
	public boolean send(JDSCommand command)throws JDSException;
}
