package com.ds.context;

import com.ds.common.JDSException;
import com.ds.common.util.ClassUtility;
import com.ds.engine.ConnectInfo;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.server.JDSServer;
import com.ds.server.eumus.ConfigCode;

import java.util.HashMap;
import java.util.Map;


public abstract class JDSActionContext implements JDSContext {
    static ThreadLocal jdsactionContext = new JDSActionContextLocal();

    public static JDSContext getActionContext() {
        JDSContext context = (JDSContext) jdsactionContext.get();
        if (context == null) {
            context = new RunableActionContextImpl();
            jdsactionContext.set(context);
        }
        return context;
    }

    Map pagectxMap = new HashMap();

    @Override
    public Map getPagectx() {
        return pagectxMap;
    }

    @Override
    public void setPagectx(Map map) {
        this.pagectxMap = map;
    }

    /**
     * Sets the action context for the current thread.
     *
     * @param context the action context.
     */
    public static void setContext(JDSContext context) {
        jdsactionContext.set(context);
    }

    @Override
    public void remove() {
        jdsactionContext.remove();
    }

    public <T> T Par(Class<T> clazz) {
        return EsbUtil.parExpression(clazz);
    }

    private static class JDSActionContextLocal extends ThreadLocal {

        protected Object initialValue() {
            JDSActionContext context = null;
            EsbBeanFactory factory = EsbBeanFactory.getInstance();
            String clazz = factory.getEsbBeanConfig().getActionContextClass();
            if (clazz == null) {
                clazz = "com.ds.server.context.SpringMvcContextImpl";
            }
            try {
                context = (JDSActionContext) ClassUtility.loadClass(clazz).newInstance();
            } catch (InstantiationException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return context;
        }
    }

    public ConfigCode getConfigCode() {

        String syscode = (String) getSystemCode();

        ConfigCode configCode =ConfigCode.fromType(syscode);
        if (configCode==null &&JDSServer.getClusterClient().getSystem(syscode)!=null ){
            configCode = JDSServer.getClusterClient().getSystem(syscode).getConfigname();
        }else{
            try {
                configCode=JDSServer.getInstance().getCurrServerBean().getConfigCode();
            } catch (JDSException e) {
                e.printStackTrace();
            }
        }




        return configCode;
    }


    public String getSystemCode() {

        String syscode = (String) this.getParams(SYSCODE);

        if (syscode == null) {
            try {
                syscode = JDSServer.getInstance().getCurrServerBean().getId();
            } catch (JDSException e) {
                e.printStackTrace();
            }
        }
        this.getContext().put(SYSCODE, syscode);
        return syscode;
    }


}
