package com.ds.config;

import com.alibaba.fastjson.annotation.JSONField;
import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.web.RemoteConnectionManager;

import java.util.concurrent.*;

public class ResultModel<T> implements Future<T> {

    public int requestStatus;

    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, ResultModel.class);

    private static final String asyncServiceKey = "local";

    protected String token;

    private T data = null;

    @JSONField(serialize = false)
    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public T getData() {
        return data;
    }


    public void execute() {
        ExecutorService service = RemoteConnectionManager.getConntctionService(asyncServiceKey);

        new Thread() {
            @Override
            public void run() {
                try {
                    ResultModel.this.get();
                } catch (Exception e) {
                    e.printStackTrace();

                }

            }
        }.start();

        //           try {

//            service.execute(new Runnable() {
//                @Override
//                public void run() {
//
//                }
//            }).get(30, TimeUnit.SECONDS);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        } catch (ExecutionException e) {
//            e.printStackTrace();
//        } catch (TimeoutException e) {
//            e.printStackTrace();
//        }

    }

    public void setData(T data) {
        this.data = data;
    }

    public ResultModel() {
        this.requestStatus = 0;

    }

    public int getRequestStatus() {
        return requestStatus;
    }

    public void setRequestStatus(int requestStatus) {
        this.requestStatus = requestStatus;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {

        return false;
    }

    @Override
    public T get() throws JDSException {

        return data;
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {

        return data;
    }

    @JSONField(serialize = false)
    public boolean isCancelled() {

        return false;
    }

    public void setCancelled(Boolean cancelled) {

    }

    public void setDone() {

    }

    @JSONField(serialize = false)
    public boolean isDone() {

        return false;
    }

}
