package com.ds.config;

import com.ds.common.JDSException;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ListResultModel<T extends Collection> extends ResultModel<T> {

    public Integer size = -1;

    public Map<String, Object> ctx;

    public int getSize() {
        if (size == -1) {
            try {
                T object = this.get();
                if (object != null) {
                    size = (object).size();
                } else {
                    size = 0;
                }

            } catch (JDSException e) {
                //e.printStackTrace();
                size = 0;
            }
        }
        ;
        return size;
    }

    @Override
    public T get() throws JDSException {
        return super.get();
    }

    public void addCtx(String name, Object value) {
        if (ctx == null) {
            ctx = new HashMap<>();
        }
        ctx.put(name, value);
    }

    public Map<String, Object> getCtx() {
        return ctx;
    }

    public void setCtx(Map<String, Object> ctx) {
        this.ctx = ctx;
    }

    @Override
    public T getData() {
        return super.getData();
    }

    public void setSize(int size) {
        this.size = size;
    }

}
