package com.ds.common.util;

import com.ds.config.JDSUtil;

import java.io.*;

public class FileClassLoader extends ClassLoader {

    public String classPath;

    public FileClassLoader(String classPath) {
        this.classPath = classPath;
    }


    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class c = null;
        try {
            c = super.loadClass(name);
        } catch (Throwable t) {
            // System.out.println(t.getMessage() + "[class name =" + name + "]");
        }
        return c;
    }


    @Override
    public Class findClass(String className) throws ClassNotFoundException {
        Class theClass = null;
        try {
            theClass = loadClass(className);
        } catch (ClassNotFoundException e) {
            //  e.printStackTrace();
        }

        if (theClass == null) {
            try {
                if (classPath == null) {
                    classPath = JDSUtil.getJdsRealPath() + "classes";
                }

                String fileName = className.replace(".", "/") + ".class";
                File classFile = new File(classPath, fileName);
                if (!classFile.exists()) {
                    throw new ClassNotFoundException(classFile.getPath() + " 不存在");
                }

                try {
                    byte[] bs = getEntryBytes(classFile);
                    theClass = super.defineClass(className, bs, 0, bs.length);
                    if (theClass.getPackage() == null) {
                        String packageName = className.substring(0, className.lastIndexOf("."));
                        definePackage(packageName, "ESDDynPackage", "1.0.0", "ESD", null, null, null, null);
                    }

                } catch (Exception ee) {
                    ee.printStackTrace();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }

        }
        return theClass;
    }

    /**
     * 取得jar内容数据
     *
     * @return
     * @throws IOException
     */
    private byte[] getEntryBytes(File file) throws IOException {
        InputStream is = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(is.available());
        int c = 0;
        byte[] buff = new byte[10240];
        while ((c = is.read(buff)) > 0) {
            bos.write(buff, 0, c);
        }
        is.close();
        return bos.toByteArray();
    }


}
