package com.ds.common.cache.redis;

import redis.clients.jedis.Jedis;

public class TestRedisRead extends Thread {
    private final String name;
    public TestRedisRead(final int i){
        name = String.valueOf(i);
    }
    @Override
    public void run(){
        final Jedis jedis = RedisPoolUtil.getInstance("REDIS").getClient();
        final Long start = System.currentTimeMillis();
        try{
            for(int i = 1;i<=10;i++){
                System.out.println("线程是:" + Thread.currentThread().getName());
//                System.out.println(name + i +"获取的结果是："+jedis.get(name + i));
                if(jedis.get(name + i) == null){
                        System.out.println("获取为空");
//                        throw new Exception();
                }else{
                    final byte[] bytes = jedis.get((name + i).getBytes());
//                    System.out.println("获取到的对象是" + RedisPoolUtil.getInstance().unserizlize(bytes));
                }
            }
        }catch (final Exception e){
            e.printStackTrace();
        }finally{
            final Long end = System.currentTimeMillis();
            System.out.println("读线程：" + Thread.currentThread().getName() + "执行耗时："+ (end - start));
            RedisPoolUtil.getInstance("REDIS").closeConn(jedis);
            
        }
    }
}
