/**
 * $RCSfile: CommonConfig.java,v $
 * $Revision: 1.1 $
 * $Date: 2014/07/08 00:26:16 $
 * <p>
 * Copyright (C) 2003 spk, Inc. All rights reserved.
 * <p>
 * This software is the proprietary information of spk, Inc.
 * Use is subject to license terms.
 */
package com.ds.common;

import com.ds.common.property.ConfigFactory;
import com.ds.common.property.XMLProperties;
import com.ds.config.JDSConfig;
import com.ds.config.JDSConfig.Config;

import java.io.File;

/**
 * <p>
 * Title: 常用代码打包
 * </p>
 * <p>
 * Description: Get configuration properties used by this common package. The config file "common_config.xml" lied in
 * CLASSPATH will be used.
 * </p>
 * <p>
 * Copyright: Copyright (c) 2006
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 *
 * @author wenzhang li
 * @version 1.0
 */
public class CommonConfig {

    public static final String CONFIG_FILENAME = "common_config.xml";
    private static XMLProperties properties = null;

    public static String getValue(String name) {
        init();
        if (properties != null)
            return properties.getProperty(name);
        else
            return null;
    }

    public static void reLoad() {
        properties.reLoad();
        init();
    }

    public static String[] getValues(String name) {
        init();
        if (properties != null)
            return properties.getProperties(name);
        else
            return new String[0];
    }

    private static void init() {

        if (properties == null) {

            File engineConfigFile = new File(Config.configPath(), CONFIG_FILENAME);

            if (!engineConfigFile.exists()) {
                engineConfigFile = new File(Config.publicConfigPath(), CONFIG_FILENAME);
            }

             if (!engineConfigFile.exists()) {
                String path = JDSConfig.getAbsolutePath("/");
                 engineConfigFile = new File(path, CONFIG_FILENAME);
              //  engineConfigFile = new File(path + CONFIG_FILENAME);
            }
            properties = ConfigFactory.getXML(engineConfigFile.getAbsolutePath());
        }

    }

}
