package com.ds.cluster.udp;

import com.ds.enums.MsgStatus;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.jds.core.esb.util.ActionContext;

public class ClusterExeCMDControl implements Runnable {

    private final ClusterCommand command;

    ClusterExeCMDControl(ClusterCommand command) {
        this.command = command;

    }

    @Override
    public void run() {
        ActionContext.getContext().getContextMap().put("command", command);
        Object obj = EsbUtil.parExpression(command.getExpression());

        if (obj != null && Boolean.valueOf(obj.toString())) {
            UDPClient.getInstance().updateEventStatus(command.getToken(), MsgStatus.UPDATE);
        } else {
            UDPClient.getInstance().updateEventStatus(command.getToken(), MsgStatus.ERROR);
        }
    }
}
