package com.ds.cluster.service;

import com.ds.cluster.event.RegistEventBean;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.web.RuntimeLog;

import java.util.List;

/**
 * 系统管理远程方法
 * <p>
 * Title:
 * </p>
 * *
 * <p>
 * Copyright: Copyright (c) 2003-2019
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 *
 * @author wenzhangli
 * @version 3.0
 */
public interface SysEventWebManager {


    /**
     * @param url
     * @param body
     * @param sessionId
     * @param time
     * @return
     */
    ListResultModel<List<RuntimeLog>> getRunTimeLogs(String url, String body, String sessionId, Long time);


    /**
     * @param systemCode
     * @param eventKeys
     * @return
     */
    public ResultModel<Boolean> registerEvent(String systemCode, String eventKeys);


    /**
     * @param systemCode
     * @param json
     * @return
     */
    public ResultModel<Boolean> registerEventJSON(String systemCode, String json);


    /**
     * @param systemCode
     * @return
     */
    public ResultModel<Boolean> clearEventKeys(String systemCode);


    /**
     * @param systemCode
     * @param eventKey
     * @return
     */
    public ResultModel<Boolean> removeEvent(String systemCode, String eventKey);


    /**
     * @return
     */
    public ListResultModel<List<? extends ServiceBean>> getRegisterEventByCode(String sysCode);


    /**
     * @return
     */
    public ListResultModel<List<RegistEventBean>> getAllRegisterEvent();


}