package com.ds.cluster.event;

import com.ds.cluster.ServerNode;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.expression.function.AbstractFunction;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.esb.config.EsbFlowType;
import com.ds.server.JDSServer;

@EsbBeanAnnotation(id = "RepeatClusterEvent", name = "转发Cluster集群事件",  flowType = EsbFlowType.msgRepeat,expressionArr = "RepeatClusterEvent(event)", desc = "转发Cluster集群事件")
public class RepeatClusterEvent extends AbstractFunction {
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, RepeatClusterEvent.class);

    public Boolean perform(final ClusterEvent event) {

        logger.info("client satrt repeat event" + event.getSourceJson());

        try {

            final String eventId = event.getEventId();

            final String content = event.getSourceJson();

            final String eventName = event.getEventName();

            final String systemCode = event.getSystemCode();

            final ServerNode currServerBean = JDSServer.getInstance().getCurrServerBean();

            ClusterEventControl.getInstance().dispatchClusterEvent(content, eventName, eventId, systemCode);

        } catch (final JDSException e) {
            e.printStackTrace();
        } catch (final Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return true;

    }

}
