package com.ds.app;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * 人员不存在的异常类。
 * <p>Title: JDSORG组织机构中间件</p>
 * <p>Description:  </p>
 * <p></p>
 * <p>Copyright: Copyright (c) 2003-2008</p>
 * <p>Company: www.justdos.net</p>
 * @author wenzhangli
 * @version 2.0
 */
public class ModuleNotFoundException extends Exception {

	private Throwable nestedThrowable = null;

	public ModuleNotFoundException() {
		super();
	}

	public ModuleNotFoundException(String msg) {
		super(msg);
	}

	public ModuleNotFoundException(Throwable nestedThrowable) {
		this.nestedThrowable = nestedThrowable;
	}

	public ModuleNotFoundException(String msg, Throwable nestedThrowable) {
		super(msg);
		this.nestedThrowable = nestedThrowable;
	}

	public void printStackTrace() {
		super.printStackTrace();
		if (nestedThrowable != null) {
			nestedThrowable.printStackTrace();
		}
	}

	public void printStackTrace(PrintStream ps) {
		super.printStackTrace(ps);
		if (nestedThrowable != null) {
			nestedThrowable.printStackTrace(ps);
		}
	}

	public void printStackTrace(PrintWriter pw) {
		super.printStackTrace(pw);
		if (nestedThrowable != null) {
			nestedThrowable.printStackTrace(pw);
		}
	}
}