/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.util.TypeUtils;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.config.TreeListResultModel;
import com.ds.jds.core.esb.util.OgnlUtil;
import com.ds.web.annotation.AnnotationType;
import com.ds.web.annotation.NotNull;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javassist.CtClass;
import javassist.CtMethod;
import net.sf.cglib.beans.BeanMap;

public class AnnotationUtil {
    protected static final Log logger = LogFactory.getLog("JDS", AnnotationUtil.class);
    static final String[] baseMethodName = new String[]{"annotationType", "toString", "hashCode", "id", "dsmId", "repositoryId", "viewInstId", "domainId"};
    static Map<Class<? extends Annotation>, Map<String, Object>> defualtValue = new HashMap<Class<? extends Annotation>, Map<String, Object>>();

    public static <T extends Annotation> T getMethodAnnotation(Method method, Class<T> annotationClass) {
        Class<?> clazz = method.getDeclaringClass();
        T annotation = method.getAnnotation(annotationClass);
        if (annotation == null) {
            Class<?>[] insClasses;
            for (Class<?> clazz2 : insClasses = clazz.getInterfaces()) {
                if (AnnotationUtil.isInnerClass(clazz2)) continue;
                try {
                    Class clazz3 = ClassUtility.loadClass(clazz2.getName());
                    Method sMethod = clazz3.getMethod(method.getName(), method.getParameterTypes());
                    if (sMethod == null) {
                        sMethod = clazz3.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    }
                    if (sMethod != null && sMethod.getAnnotation(annotationClass) != null) {
                        return sMethod.getAnnotation(annotationClass);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return annotation;
    }

    public static <T extends Annotation> T getMethodAnnotation(CtMethod method, Class<T> annotationClass) throws ClassNotFoundException {
        CtClass clazz = method.getDeclaringClass();
        Annotation annotation = (Annotation)method.getAnnotation(annotationClass);
        try {
            if (annotation == null) {
                CtClass[] insClasses;
                for (CtClass insClass : insClasses = clazz.getInterfaces()) {
                    CtMethod sMethod;
                    if (AnnotationUtil.isInnerClass(insClass) || (sMethod = insClass.getDeclaredMethod(method.getName(), method.getParameterTypes())) == null || sMethod.getAnnotation(annotationClass) == null) continue;
                    return (T)((Annotation)sMethod.getAnnotation(annotationClass));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)annotation;
    }

    public static <T extends Annotation> T getConstructorAnnotation(Constructor constructor, Class<T> annotationClass) {
        T annotation = constructor.getAnnotation(annotationClass);
        return annotation;
    }

    public static Set<Annotation> getAllConstructorAnnotations(Constructor constructor) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        annotations.addAll(Arrays.asList(constructor.getDeclaredAnnotations()));
        return annotations;
    }

    public static <T extends Annotation> T getClassAnnotation(Class cClass, Class<T> annotationClass) {
        T annotation = cClass.getAnnotation(annotationClass);
        try {
            if (annotation == null) {
                Class<?>[] insClasses;
                for (Class<?> clazz : insClasses = cClass.getInterfaces()) {
                    Class clazz2 = ClassUtility.loadClass(clazz.getName());
                    if (clazz2.getAnnotation(annotationClass) == null) continue;
                    return clazz2.getAnnotation(annotationClass);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return annotation;
    }

    public static <T extends Annotation> T getClassAnnotation(CtClass cClass, Class<T> annotationClass) throws ClassNotFoundException {
        Annotation annotation = (Annotation)cClass.getAnnotation(annotationClass);
        try {
            if (annotation == null) {
                CtClass[] insClasses;
                for (CtClass insClass : insClasses = cClass.getInterfaces()) {
                    if (insClass.getAnnotation(annotationClass) == null) continue;
                    return (T)((Annotation)insClass.getAnnotation(annotationClass));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)annotation;
    }

    public static Set<Annotation> getAllAnnotations(Method method) {
        Class<?>[] insClasses;
        Class<?> clazz = method.getDeclaringClass();
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        annotations.addAll(Arrays.asList(method.getDeclaredAnnotations()));
        for (Class<?> clazz2 : insClasses = clazz.getInterfaces()) {
            try {
                Class clazz3 = ClassUtility.loadClass(clazz2.getName());
                Method sMethod = clazz3.getMethod(method.getName(), method.getParameterTypes());
                if (sMethod == null) continue;
                annotations.addAll(Arrays.asList(sMethod.getDeclaredAnnotations()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return annotations;
    }

    public static <T extends Annotation> List<T> getAllAnnotations(Method method, Class<T> annotationClass) {
        Class<?>[] insClasses;
        Class<?> clazz = method.getDeclaringClass();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Annotation tannotation : method.getAnnotationsByType(annotationClass)) {
            annotations.add(tannotation);
        }
        for (Class<?> clazz2 : insClasses = clazz.getInterfaces()) {
            try {
                Class clazz3 = ClassUtility.loadClass(clazz2.getName());
                Method sMethod = clazz3.getMethod(method.getName(), method.getParameterTypes());
                if (sMethod == null) continue;
                for (Annotation tannotation : sMethod.getAnnotationsByType(annotationClass)) {
                    annotations.add(tannotation);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return annotations;
    }

    public static <T extends Annotation> List<T> getAllClassAnnotations(Class cClass, Class<T> annotationClass) {
        Class<?>[] insClasses;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Annotation tannotation : cClass.getAnnotationsByType(annotationClass)) {
            annotations.add(tannotation);
        }
        for (Class<?> insClass : insClasses = cClass.getInterfaces()) {
            for (Annotation tannotation : insClass.getAnnotationsByType(annotationClass)) {
                annotations.add(tannotation);
            }
        }
        return annotations;
    }

    public static Object getValue(Annotation annotation, String name) {
        Object obj = null;
        Class<? extends Annotation> enumType = annotation.annotationType();
        Method method = null;
        try {
            method = enumType.getMethod(name, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            try {
                obj = method.invoke((Object)annotation, null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static Object[] getValues(Annotation annotation, String name) {
        Object[] obj = null;
        Class<? extends Annotation> enumType = annotation.annotationType();
        Method method = null;
        try {
            method = enumType.getMethod(name, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            if (method != null) {
                obj = (Object[])method.invoke((Object)annotation, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static <T> T fillBean(Annotation annotation, T bean) {
        AnnotationUtil.fillObject(annotation, bean);
        return bean;
    }

    public static Object getDefaultValue(Class<? extends Annotation> enumType, String name) {
        for (int k = 0; k < enumType.getDeclaredMethods().length; ++k) {
            Method method = enumType.getDeclaredMethods()[k];
            if (!method.getName().equals(name)) continue;
            return method.getDefaultValue();
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<? extends Annotation> enumType, String name) {
        for (int k = 0; k < enumType.getDeclaredMethods().length; ++k) {
            Method method = enumType.getDeclaredMethods()[k];
            if (!method.getName().equals(name)) continue;
            Object[] objs = new Object[]{};
            objs = !method.getDefaultValue().getClass().isArray() ? new Object[]{method.getDefaultValue()} : (Object[])method.getDefaultValue();
            return objs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fillDefaultValue(Class<? extends Annotation> enumType, T object) {
        Class<? extends Annotation> clazz = enumType;
        synchronized (clazz) {
            Map<String, Object> valueMap = defualtValue.get(enumType);
            if (valueMap == null) {
                valueMap = new HashMap<String, Object>();
                for (int k = 0; k < enumType.getDeclaredMethods().length; ++k) {
                    Method method = enumType.getDeclaredMethods()[k];
                    Object obj = method.getDefaultValue();
                    if (obj == null || !obj.getClass().isArray() && method.getAnnotation(NotNull.class) == null) continue;
                    Field[] declaredFields = object.getClass().getDeclaredFields();
                    Field field = TypeUtils.getField(object.getClass(), (String)method.getName(), (Field[])declaredFields);
                    if (field == null) {
                        field = TypeUtils.getField(object.getClass(), (String)method.getName(), (Field[])object.getClass().getFields());
                    }
                    try {
                        if (field != null) {
                            if (obj.getClass().isArray()) {
                                valueMap.put(field.getName(), JSONObject.parseObject((String)JSONObject.toJSONString((Object)obj), (Type)field.getGenericType(), (Feature[])new Feature[0]));
                                continue;
                            }
                            valueMap.put(method.getName(), TypeUtils.cast((Object)obj, (Type)field.getGenericType(), null));
                            continue;
                        }
                        logger.error(enumType.getClass().getName() + "[" + method.getName() + "] not from in " + object.getClass().getName());
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        logger.error(enumType.getClass().getName() + "[" + method.getName() + "] of " + object.getClass().getName() + " error [ " + e + "]");
                        logger.error(method.getName() + " error in " + e);
                    }
                }
                defualtValue.put(enumType, valueMap);
            }
            OgnlUtil.setProperties(valueMap, object, false);
        }
        return object;
    }

    public static Object fillObject(Annotation annotation, Object object) {
        Class<? extends Annotation> enumType = annotation.annotationType();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (int k = 0; k < enumType.getDeclaredMethods().length; ++k) {
            Method method = enumType.getDeclaredMethods()[k];
            try {
                Object obj = method.invoke((Object)annotation, null);
                if (obj.equals(method.getDefaultValue()) && !obj.getClass().isArray() && method.getAnnotation(NotNull.class) == null) continue;
                Field[] declaredFields = object.getClass().getDeclaredFields();
                Field field = TypeUtils.getField(object.getClass(), (String)method.getName(), (Field[])declaredFields);
                if (field == null) {
                    field = TypeUtils.getField(object.getClass(), (String)method.getName(), (Field[])object.getClass().getFields());
                }
                if (field == null) continue;
                if (obj.getClass().isArray()) {
                    valueMap.put(field.getName(), JSONObject.parseObject((String)JSONObject.toJSONString((Object)obj), (Type)field.getGenericType(), (Feature[])new Feature[0]));
                    continue;
                }
                valueMap.put(method.getName(), TypeUtils.cast((Object)obj, (Type)field.getGenericType(), null));
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        OgnlUtil.setProperties(valueMap, object, false);
        return object;
    }

    public static <T> T fillBean(Annotation annotation, Class<? extends T> tClass) {
        Class<? extends Annotation> enumType = annotation.annotationType();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (int k = 0; k < enumType.getDeclaredMethods().length; ++k) {
            Method method = enumType.getDeclaredMethods()[k];
            try {
                valueMap.put(method.getName(), method.invoke((Object)annotation, null));
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        Object bean = JSONObject.parseObject((String)JSONObject.toJSONString(valueMap), tClass);
        return (T)bean;
    }

    static boolean isInnerClass(Class insClass) {
        Class[] innerClasss;
        for (Class innerClass : innerClasss = new Class[]{Serializable.class, Callable.class, Comparable.class}) {
            if (!insClass.equals(innerClass)) continue;
            return true;
        }
        return false;
    }

    static boolean isInnerClass(CtClass insClass) {
        Class[] innerClasss;
        for (Class innerClass : innerClasss = new Class[]{Serializable.class, Callable.class, Comparable.class}) {
            if (!insClass.equals(innerClass)) continue;
            return true;
        }
        return false;
    }

    private static StringBuffer toEnumsString(StringBuffer buffer, Object obj) {
        if (obj instanceof String) {
            buffer.append("\"" + obj + "\"");
        } else if (obj.getClass().isEnum()) {
            buffer.append(obj.getClass().getSimpleName() + "." + obj);
        } else if (obj instanceof Annotation) {
            AnnotationUtil.toAnnotationStr(buffer, (Annotation)obj);
        } else if (obj instanceof Class) {
            buffer.append(((Class)obj).getSimpleName() + ".class");
        } else {
            buffer.append(obj);
        }
        return buffer;
    }

    private static StringBuffer toEnumsArr(StringBuffer buffer, Object[] objs) {
        buffer.append("{");
        for (Object obj : objs) {
            AnnotationUtil.toEnumsString(buffer, obj);
            buffer.append(",");
        }
        if (buffer.toString().endsWith(",")) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("}");
        return buffer;
    }

    private static StringBuffer toEnumsArr(StringBuffer buffer, Collection objs) {
        buffer.append("{");
        for (Object obj : objs) {
            AnnotationUtil.toEnumsString(buffer, obj);
            buffer.append(",");
        }
        if (buffer.toString().endsWith(",")) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("}");
        return buffer;
    }

    private static String toAnnotationStr(Class clazz, Map<String, Object> map) {
        StringBuffer buffer = new StringBuffer("@");
        buffer.append(clazz.getSimpleName());
        if (map.size() > 0) {
            buffer.append("(");
            List<String> methodSet = Arrays.asList(baseMethodName);
            for (String key : map.keySet()) {
                Object objs;
                if (map.get(key) == null || methodSet.contains(key)) continue;
                buffer.append(key + "=");
                if (map.get(key) instanceof Collection) {
                    objs = (Object[])map.get(key);
                    if (objs.isEmpty()) {
                        objs = (Collection)map.get(key + "Class");
                    }
                    AnnotationUtil.toEnumsArr(buffer, (Collection)objs);
                } else if (map.get(key).getClass().isArray()) {
                    objs = (Object[])map.get(key);
                    AnnotationUtil.toEnumsArr(buffer, objs);
                } else {
                    Object obj = map.get(key);
                    AnnotationUtil.toEnumsString(buffer, obj);
                }
                buffer.append(",");
            }
            if (buffer.toString().endsWith(",")) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static String toAnnotationStr(Class<Annotation> annotationType, List objs) {
        HashMap sourceMap = new HashMap();
        for (Object obj : objs) {
            BeanMap beanMap = BeanMap.create(obj);
            sourceMap.putAll(beanMap);
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (int k = 0; k < annotationType.getDeclaredMethods().length; ++k) {
            Method method = annotationType.getDeclaredMethods()[k];
            List<String> methodSet = Arrays.asList(baseMethodName);
            if (methodSet.contains(method.getName())) continue;
            if (method.getReturnType().isArray()) {
                Object[] values = (Object[])sourceMap.get(method.getName());
                if (values == null || values.length <= 0 || method.getDefaultValue().equals(values)) continue;
                valueMap.put(method.getName(), values);
                continue;
            }
            Object value = sourceMap.get(method.getName());
            if (value == null || value.equals(method.getDefaultValue())) continue;
            valueMap.put(method.getName(), value);
        }
        return AnnotationUtil.toAnnotationStr(annotationType, valueMap);
    }

    public static String toAnnotationStr(Object obj, Map<String, Object> defalutMap) {
        Class enumType = AnnotationUtil.getClassAnnotation(obj.getClass(), AnnotationType.class).clazz();
        BeanMap beanMap = BeanMap.create((Object)obj);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (int k = 0; k < enumType.getDeclaredMethods().length; ++k) {
            Object defaultValue;
            Method method = enumType.getDeclaredMethods()[k];
            List<String> methodSet = Arrays.asList(baseMethodName);
            if (methodSet.contains(method.getName())) continue;
            if (method.getReturnType().isArray()) {
                Object[] valueArr;
                Object[] objects;
                Object values = beanMap.get((Object)method.getName());
                if (!(values instanceof Collection) || ((Collection)values).size() <= 0 || AnnotationUtil.equalObjects(objects = (Object[])defalutMap.get(method.getName()), valueArr = ((Collection)values).toArray())) continue;
                valueMap.put(method.getName(), values);
                continue;
            }
            Object value = beanMap.get((Object)method.getName());
            if (value == null || value.equals(defaultValue = TypeUtils.cast((Object)defalutMap.get(method.getName()), value.getClass(), null))) continue;
            valueMap.put(method.getName(), value);
        }
        return AnnotationUtil.toAnnotationStr(enumType, valueMap);
    }

    public static String toAnnotationStr(Object obj) {
        Class enumType = AnnotationUtil.getClassAnnotation(obj.getClass(), AnnotationType.class).clazz();
        BeanMap beanMap = BeanMap.create((Object)obj);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (int k = 0; k < enumType.getDeclaredMethods().length; ++k) {
            Object defaultValue;
            Method method = enumType.getDeclaredMethods()[k];
            List<String> methodSet = Arrays.asList(baseMethodName);
            if (methodSet.contains(method.getName())) continue;
            if (method.getReturnType().isArray()) {
                Object[] valueArr;
                Object[] objects;
                Object values = beanMap.get((Object)method.getName());
                if (!(values instanceof Collection) || ((Collection)values).size() <= 0 || AnnotationUtil.equalObjects(objects = (Object[])method.getDefaultValue(), valueArr = ((Collection)values).toArray())) continue;
                valueMap.put(method.getName(), values);
                continue;
            }
            if (method.getReturnType() == Boolean.TYPE) {
                Boolean defaultValue2 = (boolean)((Boolean)method.getDefaultValue());
                Object value = beanMap.get((Object)method.getName());
                if (value == null || Boolean.valueOf((Boolean)value).equals(defaultValue2)) continue;
                valueMap.put(method.getName(), value);
                continue;
            }
            Object value = beanMap.get((Object)method.getName());
            if (value == null || value.equals(defaultValue = TypeUtils.cast((Object)method.getDefaultValue(), value.getClass(), null))) continue;
            valueMap.put(method.getName(), value);
        }
        return AnnotationUtil.toAnnotationStr(enumType, valueMap);
    }

    public static Map getAnnotationOtherValue(Annotation annotation) {
        Class<? extends Annotation> enumType = annotation.annotationType();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (int k = 0; k < enumType.getDeclaredMethods().length; ++k) {
            Method method = enumType.getDeclaredMethods()[k];
            List<String> methodSet = Arrays.asList(baseMethodName);
            try {
                if (methodSet.contains(method.getName())) continue;
                if (method.getReturnType().isArray()) {
                    Object values = method.invoke((Object)annotation, null);
                    if (!(values instanceof Collection) || ((Collection)values).size() <= 0 || method.getDefaultValue().equals(values)) continue;
                    valueMap.put(method.getName(), values);
                    continue;
                }
                Object value = method.invoke((Object)annotation, null);
                if (value.equals(method.getDefaultValue())) continue;
                valueMap.put(method.getName(), value);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return valueMap;
    }

    public static String toAnnotationStr(Annotation annotation) {
        StringBuffer buffer = new StringBuffer();
        Map valueMap = AnnotationUtil.getAnnotationOtherValue(annotation);
        buffer.append(AnnotationUtil.toAnnotationStr(annotation.annotationType(), (Map<String, Object>)valueMap));
        return buffer.toString();
    }

    public static StringBuffer toAnnotationStr(StringBuffer buffer, Annotation annotation) {
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        Map valueMap = AnnotationUtil.getAnnotationOtherValue(annotation);
        buffer.append(AnnotationUtil.toAnnotationStr(annotation.annotationType(), (Map<String, Object>)valueMap));
        return buffer;
    }

    public static StringBuffer toTypeStr(StringBuffer methodBuffer, ParameterizedType type) {
        Type rawTye = type.getRawType();
        if (rawTye != null) {
            if (rawTye == Map.class || rawTye == HashMap.class) {
                Type keyType = type.getActualTypeArguments()[0];
                methodBuffer.append("Map");
                methodBuffer.append("<");
                methodBuffer = AnnotationUtil.toType(methodBuffer, keyType);
                methodBuffer.append(",");
                Type valueType = type.getActualTypeArguments()[1];
                methodBuffer = AnnotationUtil.toType(methodBuffer, valueType);
                methodBuffer.append(">");
            } else {
                if (ListResultModel.class.isAssignableFrom((Class)rawTye)) {
                    methodBuffer.append("ListResultModel");
                } else if (rawTye == ResultModel.class) {
                    methodBuffer.append("ResultModel");
                } else if (rawTye == TreeListResultModel.class) {
                    methodBuffer.append("TreeListResultModel");
                } else {
                    methodBuffer = rawTye == Set.class || rawTye == HashSet.class || rawTye == TreeSet.class || rawTye == Collection.class || rawTye == List.class || rawTye == ArrayList.class ? AnnotationUtil.toType(methodBuffer, rawTye) : AnnotationUtil.toType(methodBuffer, rawTye);
                }
                if (type.getActualTypeArguments() != null) {
                    methodBuffer.append("<");
                    Type itemType = type.getActualTypeArguments()[0];
                    methodBuffer = itemType instanceof Class ? AnnotationUtil.toType(methodBuffer, itemType) : AnnotationUtil.toType(methodBuffer, itemType);
                    methodBuffer.append(">");
                }
            }
        }
        return methodBuffer;
    }

    public static StringBuffer toType(Type type) {
        StringBuffer methodBuffer = new StringBuffer("");
        return AnnotationUtil.toType(methodBuffer, type);
    }

    public static StringBuffer toType(Class type, Type genericType) {
        StringBuffer methodBuffer = new StringBuffer("");
        if (genericType != null && !genericType.equals(type)) {
            methodBuffer = AnnotationUtil.toType(methodBuffer, genericType);
        } else {
            methodBuffer.append(type.getSimpleName());
        }
        return methodBuffer;
    }

    public static StringBuffer toReturnStr(Method method) {
        StringBuffer methodBuffer = new StringBuffer();
        Type type = method.getGenericReturnType();
        Class<?> clazz = method.getReturnType();
        methodBuffer.append(clazz.getSimpleName());
        if (type != null) {
            methodBuffer.append("<");
            methodBuffer = AnnotationUtil.toType(methodBuffer, type);
            methodBuffer.append(">");
        }
        return methodBuffer;
    }

    public static StringBuffer toReturnStr(Field field) {
        StringBuffer methodBuffer = new StringBuffer();
        Type type = field.getGenericType();
        Class<?> clazz = field.getType();
        methodBuffer.append(clazz.getSimpleName());
        if (type != null) {
            methodBuffer.append("<");
            methodBuffer = AnnotationUtil.toType(methodBuffer, type);
            methodBuffer.append(">");
        }
        return methodBuffer;
    }

    public static StringBuffer toType(StringBuffer methodBuffer, Type type) {
        if (type instanceof ParameterizedType) {
            methodBuffer = AnnotationUtil.toTypeStr(methodBuffer, (ParameterizedType)type);
        } else if (type instanceof WildcardType) {
            methodBuffer = AnnotationUtil.toWildcardType(methodBuffer, (WildcardType)type);
        } else if (TypeUtils.loadClass((String)type.getTypeName()) != null) {
            methodBuffer.append(TypeUtils.loadClass((String)type.getTypeName()).getSimpleName());
        } else {
            methodBuffer.append(type.getTypeName() + " ");
        }
        return methodBuffer;
    }

    public static StringBuffer toWildcardType(StringBuffer methodBuffer, WildcardType type) {
        if (type.getTypeName().equals("?")) {
            methodBuffer.append(type.getTypeName());
        } else if (type.getTypeName().startsWith("?") && type.getUpperBounds().length > 0) {
            methodBuffer.append("? extends ");
            methodBuffer.append(((Class)type.getUpperBounds()[0]).getSimpleName());
        }
        return methodBuffer;
    }

    public static boolean equalObjects(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        List<Object> a2List = Arrays.asList(a2);
        for (int i = 0; i < length; ++i) {
            Object o1 = a[i];
            if (a2List.contains(o1)) continue;
            return false;
        }
        return true;
    }
}

