/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web.invocation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.context.JDSActionContext;
import com.ds.web.ConnectionLogFactory;
import com.ds.web.JSONGenSetInvocationHandler;
import com.ds.web.RemoteConnectionManager;
import com.ds.web.RuntimeLog;
import com.ds.web.util.JSONGenUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;

public class RemoteListResultModel<T extends Collection>
extends ListResultModel<T> {
    private final Class tClass;
    private Future<Content> future;
    private Class iClass;
    @JSONField(serialize=false)
    private ResultModel<T> model;
    private String url;
    private static final Log logger = LogFactory.getLog("JDS", RemoteListResultModel.class);
    private static final String asyncServiceKey = "async";
    @JSONField(name="data")
    private JSONArray dataObj;

    RemoteListResultModel(String url, final String token, Request request, Class tClass, final Class iClass, Async async) {
        this.iClass = iClass;
        this.tClass = tClass;
        this.url = url;
        this.token = token;
        if (System.getProperty("JDShttpProxy") != null) {
            request.viaProxy(System.getProperty("JDShttpProxy"));
        }
        this.future = async.execute(request, (FutureCallback)new FutureCallback<Content>(){

            public void failed(Exception ex) {
                ex.printStackTrace();
            }

            public void completed(Content content) {
                if (!InputStream.class.isAssignableFrom(iClass)) {
                    String json = content.asString();
                    logger.debug("return " + json);
                    RuntimeLog log = ConnectionLogFactory.getInstance().getLog(token);
                    if (log != null) {
                        log.setBodyJson(json);
                        log.setEndTime(System.currentTimeMillis());
                        log.setTime(log.getEndTime() - log.getStartTime());
                    }
                }
            }

            public void cancelled() {
            }
        });
    }

    @Override
    public void execute() {
        ExecutorService service = RemoteConnectionManager.getConntctionService(asyncServiceKey);
        service.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    RemoteListResultModel.this.get();
                }
                catch (JDSException e) {
                    logger.error("url==" + RemoteListResultModel.this.url);
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public int getSize() {
        if (this.size == -1) {
            try {
                Object object = this.get();
                this.size = object != null ? Integer.valueOf(object.size()) : Integer.valueOf(0);
            }
            catch (JDSException e) {
                this.size = 0;
            }
        }
        return this.size;
    }

    @Override
    public int getRequestStatus() {
        int status = -1;
        try {
            status = this.getModel().getRequestStatus();
        }
        catch (JDSException jDSException) {
            // empty catch block
        }
        return status;
    }

    @JSONField(serialize=false)
    public ResultModel<T> getModel() throws JDSException {
        if (this.model == null) {
            this.get();
        }
        return this.model;
    }

    @Override
    @JSONField(serialize=false)
    public T getData() {
        Object data = null;
        try {
            data = this.get();
        }
        catch (JDSException e) {
            this.setRequestStatus(-1);
        }
        return (T)data;
    }

    public Object getDataObj() {
        this.getData();
        return this.dataObj;
    }

    @JSONField(serialize=false)
    Future<Content> getFuture() {
        return this.future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws JDSException {
        try {
            Content content = this.future.get();
            if (InputStream.class.isAssignableFrom(this.iClass) && content.getType().getMimeType().toString().equals(ContentType.APPLICATION_OCTET_STREAM.toString())) {
                return (T)((Collection)((Object)content.asStream()));
            }
            String modelStr = content.asString();
            return (T)((Collection)this.getResultModel(modelStr).getData());
        }
        catch (InterruptedException e) {
            throw new JDSException("\u670d\u52a1\u5668\u5f02\u5e38", 500);
        }
        catch (ExecutionException e) {
            if (e instanceof JDSException) {
                throw (JDSException)e;
            }
            throw new JDSException("\u670d\u52a1\u5668\u5f02\u5e38", 500);
        }
    }

    @Override
    public T get() throws JDSException {
        try {
            Content content = this.future.get();
            if (InputStream.class.isAssignableFrom(this.iClass) && content.getType().getMimeType().toString().equals(ContentType.APPLICATION_OCTET_STREAM.toString())) {
                return (T)((Collection)((Object)content.asStream()));
            }
            String modelStr = this.future.get().asString();
            return (T)((Collection)this.getResultModel(modelStr).getData());
        }
        catch (InterruptedException e) {
            throw new JDSException("\u670d\u52a1\u5668\u5f02\u5e38", 500);
        }
        catch (ExecutionException e) {
            if (e instanceof JDSException) {
                throw (JDSException)e;
            }
            throw new JDSException("\u670d\u52a1\u5668\u5f02\u5e38", 500);
        }
    }

    @Override
    @JSONField(serialize=false)
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    @JSONField(serialize=false)
    public boolean isDone() {
        return this.future.isDone();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @JSONField(serialize=false)
    ResultModel<T> getResultModel(String modelStr) throws JDSException {
        void var2_8;
        Integer size;
        Object var2_2 = null;
        JSONObject jsonObj = JSONObject.parseObject((String)modelStr);
        if (jsonObj == null) throw new JDSException("\u670d\u52a1\u5668\u683c\u5f0f\u9519\u8bef:" + modelStr, 500);
        if (jsonObj.get((Object)"requestStatus") == null) {
            throw new JDSException("\u670d\u52a1\u5668\u683c\u5f0f\u9519\u8bef:" + modelStr, 500);
        }
        if (Integer.valueOf(jsonObj.get((Object)"requestStatus").toString()) != 0) {
            ErrorListResultModel errmodel;
            this.setSize(0);
            this.model = errmodel = (ErrorListResultModel)JSONObject.parseObject((String)modelStr, ErrorListResultModel.class);
            throw new JDSException(errmodel.getErrdes(), errmodel.getErrcode());
        }
        this.requestStatus = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
        Object data = jsonObj.get((Object)"data");
        if (!(data instanceof JSONArray)) {
            ErrorResultModel errmodel;
            this.model = errmodel = (ErrorResultModel)JSONObject.parseObject((String)modelStr, ErrorResultModel.class);
            throw new JDSException("\u6570\u636e\u8fd4\u56de\u7c7b\u578b\u9519\u8bef\uff01\u5f53\u524d\u65b9\u6cd5\u53ea\u5141\u8bb8\uff0c\u6570\u7ec4\u7c7b\u578b\u6570\u636e\uff01", 9000);
        }
        Class jsonClass = this.iClass;
        this.dataObj = (JSONArray)data;
        jsonClass = JSONGenUtil.fillSetMethod(this.iClass);
        if (!jsonClass.equals(this.iClass)) {
            List josnobj = JSONArray.parseArray((String)jsonObj.getString("data"), (Class)jsonClass);
            ArrayList<Object> rmObj = new ArrayList<Object>();
            for (Object json : josnobj) {
                Object proxyObj = null;
                if (json != null) {
                    proxyObj = Enhancer.create(Object.class, (Class[])new Class[]{this.iClass, jsonClass}, (Callback)new JSONGenSetInvocationHandler(json));
                }
                rmObj.add(proxyObj);
                ArrayList<Object> arrayList = rmObj;
            }
        } else {
            List list = JSONArray.parseArray((String)jsonObj.getString("data"), (Class)this.iClass);
        }
        if ((size = jsonObj.getInteger("size")) != null) {
            ListResultModel listResultModel = new ListResultModel();
            listResultModel.setSize(size);
            JDSActionContext.getActionContext().getContext().put(this.iClass.getName() + "[JDS_SIZE]", size);
            this.model = listResultModel;
            this.setSize(size);
        } else {
            this.model = new ResultModel();
            this.setSize(this.dataObj.size());
        }
        if (this.tClass != null && Set.class.isAssignableFrom(this.tClass)) {
            void var2_6;
            LinkedHashSet linkedHashSet = new LinkedHashSet(var2_6);
        }
        this.model.setData(var2_8);
        return this.model;
    }

    private T newProxy(Class<T> clazz) {
        MethodInterceptor staticMethodInterceptor = new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] objects, MethodProxy proxy) {
                String name = method.getName();
                Object returnobj = null;
                try {
                    returnobj = method.invoke(returnobj, objects);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return returnobj;
            }
        };
        Collection obj = (Collection)Enhancer.create(Object.class, (Class[])new Class[]{clazz}, (Callback)staticMethodInterceptor);
        return (T)obj;
    }
}

