/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web.invocation;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ds.client.JDSSessionFactory;
import com.ds.cluster.ClusterMananerFactory;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.eumus.ConfigCode;
import com.ds.web.APIConfigFactory;
import com.ds.web.ConnectionLogFactory;
import com.ds.web.LocalMultipartFile;
import com.ds.web.RemoteConnectionManager;
import com.ds.web.RequestMappingBean;
import com.ds.web.RuntimeLog;
import com.ds.web.invocation.RemoteListResultModel;
import com.ds.web.invocation.RemoteResultModel;
import com.ds.web.util.JSONGenUtil;
import com.ds.web.util.PageUtil;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Executor;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.util.CharsetUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

public class HttpClientInvocationHandler
implements InvocationHandler {
    public static final String serverUrlKey = "ServerUrl";
    public static final String JDSUSERID = "JDSUSERID";
    public static final String jdstime = "jdstime";
    private JDSClientService clientService;
    private String serverKey;
    private CtClass ctClass;
    private static final SerializeConfig config = new SerializeConfig();
    private static final Log logger;

    public HttpClientInvocationHandler(JDSClientService clientService, CtClass ctClass, String serverKey) throws JDSException {
        if (clientService == null) {
            throw new JDSException("not login error,place login!");
        }
        if (serverKey == null) {
            throw new JDSException("serverUlr  err:");
        }
        this.clientService = clientService;
        this.serverKey = serverKey;
        this.ctClass = ctClass;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.clientService = this.getCurrJDSClient();
        Request request = null;
        JDSContext jdcontext = JDSActionContext.getActionContext();
        Map context = jdcontext.getContext();
        String requestJson = "";
        String serverUrl = this.serverKey;
        String sessionId = jdcontext.getSessionId();
        if (this.clientService.getSessionHandle() != null) {
            sessionId = this.clientService.getSessionHandle().getSessionID();
        }
        if (!this.serverKey.startsWith("http://")) {
            JDSServer.getInstance();
            if (JDSServer.getClusterClient().getServerNodeById(this.serverKey) != null) {
                serverUrl = ClusterMananerFactory.getClusterManager(ConfigCode.fromType(this.serverKey)).getSubServer(sessionId, ConfigCode.fromType(this.serverKey)).getUrl();
            }
        }
        if (context.get(serverUrlKey) != null && !context.get(serverUrlKey).equals("")) {
            serverUrl = (String)context.get(serverUrlKey);
        }
        Async async = Async.newInstance().use((Executor)RemoteConnectionManager.getConntctionService(serverUrl));
        RequestMappingBean mapping = APIConfigFactory.getInstance().getMapping(method, this.ctClass);
        String url = serverUrl + mapping.getFristUrl();
        url = !url.contains("?") ? url + "?" + "JSESSIONID" + "=" + sessionId : url + "&" + "JSESSIONID" + "=" + sessionId;
        String userId = this.clientService.getConnectInfo().getUserID();
        String syscode = this.clientService.getSystemCode();
        url = url + "&" + "SYSID" + "=" + syscode + "&" + JDSUSERID + "=" + userId + "&" + jdstime + "=" + System.currentTimeMillis();
        CtMethod[] cms = this.ctClass.getDeclaredMethods(method.getName());
        CtMethod cm = null;
        for (CtMethod ccm : cms) {
            if (ccm.getParameterTypes().length != method.getParameterTypes().length) continue;
            cm = ccm;
        }
        MethodInfo methodInfo = cm.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        String[] paramNames = new String[cm.getParameterTypes().length];
        TreeMap<Integer, String> sortMap = new TreeMap<Integer, String>();
        for (int i = 0; i < attr.tableLength(); ++i) {
            sortMap.put(attr.index(i), attr.variableName(i));
            int pos = Modifier.isStatic((int)cm.getModifiers()) ? 0 : 1;
            paramNames = Arrays.copyOfRange(sortMap.values().toArray(new String[0]), pos, paramNames.length + pos);
        }
        if (ListResultModel.class.isAssignableFrom(method.getReturnType())) {
            url = PageUtil.appUrlParams(url, paramNames);
        }
        if (args.length == 0) {
            logger.info(url + " {args  0 }");
            request = Request.Post((String)url);
        } else if (args.length == 1) {
            Object[][] annotations = cm.getParameterAnnotations();
            Object[] annotationa = annotations[0];
            Object obj = args[0];
            for (Object annotation : annotationa) {
                String userData;
                if (!RequestBody.class.isAssignableFrom(annotation.getClass())) continue;
                requestJson = userData = JSONObject.toJSON((Object)obj, (SerializeConfig)config).toString();
                logger.debug(url + " {args 1 body}");
                logger.debug(JSONObject.toJSONString((Object)obj, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]));
                request = Request.Post((String)url).bodyString(userData, ContentType.APPLICATION_JSON);
            }
        }
        if (request == null) {
            int i;
            Form form = Form.form();
            Boolean isMulti = false;
            for (i = 0; i < paramNames.length; ++i) {
                if (!(args[i] instanceof MultipartFile)) continue;
                isMulti = true;
            }
            if (isMulti.booleanValue()) {
                MultipartEntityBuilder reqEntitybuild = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(CharsetUtils.get((String)"UTF-8"));
                for (int i2 = 0; i2 < paramNames.length; ++i2) {
                    String paramName = paramNames[i2];
                    if (args[i2] instanceof String || args[i2] instanceof Integer || args[i2] instanceof Long) {
                        reqEntitybuild.addTextBody(paramName, JSONObject.toJSON((Object)args[i2], (SerializeConfig)config).toString());
                        continue;
                    }
                    if (args[i2] instanceof MultipartFile) {
                        LocalMultipartFile part = (LocalMultipartFile)args[i2];
                        InputStreamBody fileStream = new InputStreamBody(part.getInputStream(), paramName);
                        reqEntitybuild.addPart(paramName, (ContentBody)fileStream);
                        continue;
                    }
                    if (args[i2].getClass().isAssignableFrom(String[].class) || args[i2].getClass().isAssignableFrom(Integer[].class) || args[i2].getClass().isAssignableFrom(Long[].class)) {
                        Object[] array;
                        for (Object obj : array = (Object[])args[i2]) {
                            reqEntitybuild.addTextBody(paramName, JSONObject.toJSON((Object)args[i2], (SerializeConfig)config).toString());
                        }
                        continue;
                    }
                    reqEntitybuild.addTextBody(paramName, JSONObject.toJSON((Object)args[i2], (SerializeConfig)config).toString());
                }
                logger.debug(url + " {args 1 body}");
                request = Request.Post((String)url).body(reqEntitybuild.build());
            } else {
                for (i = 0; i < paramNames.length; ++i) {
                    String paramName = paramNames[i];
                    String userData = "";
                    if (args[i] == null) continue;
                    if (args[i] instanceof String || args[i] instanceof Integer || args[i] instanceof Long) {
                        userData = args[i].toString();
                        form.add(paramName, userData);
                        continue;
                    }
                    if (args[i].getClass().isAssignableFrom(String[].class) || args[i].getClass().isAssignableFrom(Integer[].class) || args[i].getClass().isAssignableFrom(Long[].class)) {
                        Object[] array;
                        for (Object obj : array = (Object[])args[i]) {
                            form.add(paramName, obj.toString());
                        }
                        continue;
                    }
                    userData = JSONObject.toJSON((Object)args[i], (SerializeConfig)config).toString();
                    form.add(paramName, userData);
                }
                logger.debug(url + " {paramNames " + paramNames.length + "}");
                requestJson = form.build().toString();
                logger.debug(requestJson);
                request = Request.Post((String)url).bodyForm((Iterable)form.build(), Charset.forName("utf-8"));
            }
        }
        Class iClass = JSONGenUtil.getInnerReturnType(method);
        ResultModel resultModel = null;
        String token = UUID.randomUUID().toString();
        RuntimeLog log = ConnectionLogFactory.getInstance().createLog(token, serverUrl, mapping.getFristUrl(), sessionId);
        log.setStartTime(System.currentTimeMillis());
        log.setRequestJson(requestJson);
        if (ListResultModel.class.isAssignableFrom(method.getReturnType())) {
            Class tClass = JSONGenUtil.getListReturnType(method);
            resultModel = new RemoteListResultModel(url, token, request, tClass, iClass, async);
        } else {
            resultModel = new RemoteResultModel(url, token, request, iClass, async);
        }
        request.setHeader("Proxy-Client-IP", JDSActionContext.getActionContext().getIpAddr());
        return resultModel;
    }

    public JDSClientService getCurrJDSClient() {
        JDSContext context = JDSActionContext.getActionContext();
        JDSSessionFactory factory = new JDSSessionFactory(context);
        String systemCode = JDSActionContext.getActionContext().getSystemCode();
        String sessionId = JDSActionContext.getActionContext().getSessionId();
        JDSClientService client = null;
        try {
            client = factory.getClientService(context.getConfigCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (client == null && sessionId != null) {
            try {
                client = factory.getJDSClientBySessionId(sessionId, context.getConfigCode());
            }
            catch (JDSException jDSException) {
                // empty catch block
            }
        }
        return client;
    }

    static {
        HttpClientInvocationHandler.config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
        logger = LogFactory.getLog("JDS", HttpClientInvocationHandler.class);
    }
}

