/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web.client;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.esb.config.ContextType;
import com.ds.esb.config.annotation.AbstractAnnotationtExpressionTempManager;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.web.client.GetClientService;
import com.ds.web.util.AnnotationUtil;
import java.util.Set;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringMVCTempXMLProxy
extends AbstractAnnotationtExpressionTempManager {
    private static final Log logger = LogFactory.getLog("JDS", SpringMVCTempXMLProxy.class);

    public SpringMVCTempXMLProxy(EsbBean esbBean) {
        this.esbBean = esbBean;
    }

    @Override
    public void fillBean(Set<Class<?>> classList) {
        for (Class<?> clazz : classList) {
            RequestMapping mvcConsol = AnnotationUtil.getClassAnnotation(clazz, RequestMapping.class);
            if (mvcConsol == null) continue;
            ExpressionTempBean expressionTempBean = new ExpressionTempBean();
            String name = mvcConsol.value()[0] + "/";
            String id = clazz.getSimpleName();
            expressionTempBean.setDataType(ContextType.Action);
            expressionTempBean.setExpressionArr("GetClientService(\"" + clazz.getName() + "\",\"" + this.esbBean.getServerUrl() + "\")");
            expressionTempBean.setClazz(GetClientService.class.getName());
            expressionTempBean.setId(id);
            expressionTempBean.setJspUrl(mvcConsol.value()[0]);
            expressionTempBean.setDesc(mvcConsol.value()[0]);
            expressionTempBean.setName(name);
            expressionTempBean.setServerUrl(this.esbBean.getServerUrl());
            expressionTempBean.setMainClass(clazz.getName());
            expressionTempBean.setReturntype(clazz.getSimpleName());
            this.nameMap.put(name, expressionTempBean);
            this.idMap.put(id, expressionTempBean);
            this.serviceBeanList.add(expressionTempBean);
        }
    }
}

