/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web.annotation;

import com.ds.enums.Enumstype;
import com.ds.web.annotation.ViewGroupType;
import java.util.HashSet;
import java.util.Set;

public enum ViewType implements Enumstype
{
    frame("\u6846\u67b6", "spafont spa-icon-c-databinder", ViewGroupType.nav),
    nav("\u5bfc\u822a", "spafont spa-icon-shukongjian", ViewGroupType.nav),
    layout("\u5e03\u5c40", "spafont spa-icon-c-buttonviews", ViewGroupType.nav),
    grid("\u5217\u8868", "spafont spa-icon-c-grid", ViewGroupType.view),
    gallery("\u753b\u5eca", "spafont spa-icon-c-iconslist", ViewGroupType.view),
    form("\u8868\u5355", "spafont spa-icon-c-richeditor", ViewGroupType.view),
    foldingtree("folding\u6811\u5f62", "spafont spa-icon-shukongjian", ViewGroupType.view),
    tree("\u6570\u636e\u6811", "spafont spa-icon-c-shukongjian", ViewGroupType.view),
    navtree("\u5bfc\u822a\u6811", "spafont spa-icon-shukongjian", ViewGroupType.nav),
    charts("\u7edf\u8ba1\u56fe\u8868", "xui-uicmd-location", ViewGroupType.charts),
    svg("SVG\u7ed8\u56fe", "spafont spa-icon-editpath", ViewGroupType.svg),
    module("\u5185\u5d4c\u6a21\u5757", "spafont spa-icon-conf", ViewGroupType.module),
    dic("\u5b57\u5178\u8f85\u52a9", "spafont spa-icon-function", ViewGroupType.dic),
    domain("\u901a\u7528\u57df", "spafont spa-icon-shukongjian", ViewGroupType.domain);

    private final String name;
    private final String imageClass;
    private ViewGroupType groupType;

    private ViewType(String name, String imageClass, ViewGroupType groupType) {
        this.name = name;
        this.imageClass = imageClass;
        this.groupType = groupType;
    }

    public static ViewType fromType(String type) {
        ViewType defaultViewType = domain;
        if (type != null) {
            for (ViewType viewType : ViewType.values()) {
                if (!viewType.getType().equals(type)) continue;
                defaultViewType = viewType;
            }
        }
        return defaultViewType;
    }

    public static Set<ViewType> getGroupView(ViewGroupType groupType) {
        HashSet<ViewType> viewTypes = new HashSet<ViewType>();
        if (groupType != null) {
            for (ViewType viewType : ViewType.values()) {
                if (!viewType.getGroupType().equals(groupType)) continue;
                viewTypes.add(viewType);
            }
        }
        return viewTypes;
    }

    public ViewGroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(ViewGroupType groupType) {
        this.groupType = groupType;
    }

    public String getImageClass() {
        return this.imageClass;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public String getType() {
        return this.name();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

