/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web;

import com.alibaba.fastjson.annotation.JSONField;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.enums.db.MethodChinaName;
import com.ds.org.conf.OrgConstants;
import com.ds.web.RequestParamBean;
import com.ds.web.util.AnnotationUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.web.bind.annotation.RequestParam;

public class ConstructorBean<T> {
    @JSONField(serialize=false)
    public Constructor constructor;
    public String name;
    public String className;
    public MethodChinaName methodChinaName;
    public Set<RequestParamBean> paramSet = new LinkedHashSet<RequestParamBean>();
    public Map<String, Object> defaultParamsValueMap = new LinkedHashMap<String, Object>();
    public Set<String> requiredParams = new HashSet<String>();
    public Map<String, String> paramsMap = new LinkedHashMap<String, String>();
    private static final Log log = LogFactory.getLog(OrgConstants.CONFIG_KEY.getType(), ConstructorBean.class);

    public ConstructorBean(Constructor<T> constructor) {
        this.constructor = constructor;
        this.className = constructor.getDeclaringClass().getName();
        Type[] parameterTypes = constructor.getGenericParameterTypes();
        Class<?>[] parameterClasses = constructor.getParameterTypes();
        String[] paramNames = new String[parameterTypes.length];
        Annotation[][] annotations = constructor.getParameterAnnotations();
        this.methodChinaName = AnnotationUtil.getConstructorAnnotation(constructor, MethodChinaName.class);
        Parameter[] parameters = constructor.getParameters();
        for (int i = 0; i < paramNames.length; ++i) {
            RequestParam paramAnnotation;
            String paramName = paramNames[i];
            Parameter parameter = parameters[i];
            if ((paramName == null || paramName.equals("null") || paramName.equals("")) && parameters != null && parameters.length > i) {
                paramName = parameters[i].getName();
            }
            if ((paramAnnotation = parameter.getAnnotation(RequestParam.class)) != null) {
                if (!paramAnnotation.value().equals("")) {
                    paramName = paramAnnotation.value();
                }
                if (!paramAnnotation.defaultValue().equals("")) {
                    this.defaultParamsValueMap.put(paramName, paramAnnotation.defaultValue());
                }
                if (paramAnnotation.required()) {
                    this.requiredParams.add(paramName);
                }
            }
            HashSet<Annotation> annotationSet = new HashSet<Annotation>();
            for (Annotation annotationType : annotations[i]) {
                annotationSet.add(annotationType);
            }
            RequestParamBean paramBean = new RequestParamBean(paramName, annotationSet, parameterTypes[i], parameterClasses[i]);
            this.paramSet.add(paramBean);
            this.paramsMap.put(paramName, parameterClasses[i].getName());
        }
    }

    Set<Class> getParamClassSet() {
        LinkedHashSet<Class> paramClassSet = new LinkedHashSet<Class>();
        for (RequestParamBean paramBean : this.paramSet) {
            paramClassSet.add(paramBean.getParamClass());
        }
        return paramClassSet;
    }

    @JSONField(serialize=false)
    public Constructor<T> getSourceConstructor() throws ClassNotFoundException {
        if (this.constructor == null) {
            Class clazz = ClassUtility.loadClass(this.getClassName());
            if (this.constructor == null) {
                for (Constructor<?> innerconstructor : clazz.getConstructors()) {
                    if (!innerconstructor.getParameterTypes().equals(this.getParamClassSet().toArray())) continue;
                    this.constructor = innerconstructor;
                }
            }
        }
        return this.constructor;
    }

    public Set<String> getRequiredParams() {
        return this.requiredParams;
    }

    public void setRequiredParams(Set<String> requiredParams) {
        this.requiredParams = requiredParams;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public MethodChinaName getMethodChinaName() {
        return this.methodChinaName;
    }

    public void setMethodChinaName(MethodChinaName methodChinaName) {
        this.methodChinaName = methodChinaName;
    }

    public Set<RequestParamBean> getParamSet() {
        return this.paramSet;
    }

    public void setParamSet(Set<RequestParamBean> paramSet) {
        this.paramSet = paramSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getParamsMap() {
        return this.paramsMap;
    }

    public void setParamsMap(Map<String, String> paramsMap) {
        this.paramsMap = paramsMap;
    }
}

