/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web;

import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.web.RuntimeLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionLogFactory {
    boolean isLogger = true;
    public static final String THREAD_LOCK = "Thread Lock";
    Cache<String, RuntimeLog> logMap = CacheManagerFactory.createCache("org", "Connetciontlog", 0x1E00000, 3600000L);
    Cache<String, Set<String>> urllogListMap = CacheManagerFactory.createCache("log", "UrllogSet", 0x1E00000, 3600000L);
    static ConnectionLogFactory instance;

    ConnectionLogFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionLogFactory getInstance() {
        if (instance != null) return instance;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (instance != null) return instance;
            instance = new ConnectionLogFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public RuntimeLog getLog(String logId) {
        RuntimeLog log = (RuntimeLog)this.logMap.get(logId);
        return log;
    }

    public List<RuntimeLog> findLogs(String urlPattern, String bodyPattern, String sessionId, long time) {
        ArrayList<RuntimeLog> logs = new ArrayList<RuntimeLog>();
        if (urlPattern == null || urlPattern.equals("")) {
            urlPattern = ".*";
        }
        Pattern p = Pattern.compile(urlPattern, 2);
        Set keySet = this.urllogListMap.keySet();
        for (String key : keySet) {
            Matcher matcher = p.matcher(key);
            if (!matcher.find()) continue;
            logs.addAll(this.getLogs(key, bodyPattern, sessionId, time));
        }
        Collections.sort(logs, new Comparator<RuntimeLog>(){

            @Override
            public int compare(RuntimeLog o1, RuntimeLog o2) {
                if (o1.getStartTime() == o2.getStartTime()) {
                    return 0;
                }
                return o1.getStartTime() > o2.getStartTime() ? -1 : 1;
            }
        });
        return logs;
    }

    Set<RuntimeLog> getLogs(String url, String pattern, String sessionId, long time) {
        LinkedHashSet<RuntimeLog> logs = new LinkedHashSet<RuntimeLog>();
        Set logSet = (Set)this.urllogListMap.get(url);
        if (pattern == null || pattern.equals("")) {
            pattern = ".*";
        }
        Pattern p = Pattern.compile(pattern, 2);
        for (String logid : logSet) {
            RuntimeLog log = (RuntimeLog)this.logMap.get(logid);
            if (log == null) continue;
            if (pattern != null && !pattern.equals("")) {
                Matcher rmatcher = p.matcher(log.getBodyJson() == null ? "" : log.getBodyJson());
                Matcher bmatcher = p.matcher(log.getRequestJson() == null ? "" : log.getRequestJson());
                if (sessionId != null && !sessionId.equals("") && (log.getSessionId() == null || sessionId == null || !sessionId.equals(log.getSessionId())) || !rmatcher.find() && !bmatcher.find() || log.getTime() < time && log.getTime() >= 0L) continue;
                logs.add(log);
                continue;
            }
            logs.add(log);
        }
        return logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeLog createLog(String logid, String serviceKey, String url, String sessionId) {
        String key;
        String string = key = serviceKey + url;
        synchronized (string) {
            LinkedHashSet<String> logSet;
            RuntimeLog log = (RuntimeLog)this.logMap.get(logid);
            if (log == null) {
                log = new RuntimeLog(logid, serviceKey, url, sessionId);
                this.logMap.put(logid, log);
            }
            if ((logSet = (LinkedHashSet<String>)this.urllogListMap.get(key)) == null) {
                logSet = new LinkedHashSet<String>();
                this.urllogListMap.put(key, logSet);
            }
            logSet.add(logid);
            return log;
        }
    }

    public void clear(String url) {
        Set logSet = (Set)this.urllogListMap.get(url);
        if (logSet != null && logSet.size() > 0) {
            for (String logid : logSet) {
                RuntimeLog runtimeLog = (RuntimeLog)this.logMap.remove(logid);
            }
            this.urllogListMap.remove(url);
        }
    }
}

