/*
 * Decompiled with CFR 0.152.
 */
package com.ds.vfs;

import com.ds.common.JDSException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class VFSException
extends JDSException {
    public static final int SERVERNOTSTARTEDERROR = 10;
    public static final int SERVERSTARTERROR = 11;
    public static final int SERVERSTOPERROR = 12;
    public static final int SERVERRESTARTERROR = 13;
    public static final int SERVERSTATUSCOMMANDERROR = 14;
    public static final int SERVERSTARTCOMMANDERROR = 15;
    public static final int SERVERSTOPCOMMANDERROR = 16;
    public static final int SERVERRESTARTCOMMANDERROR = 17;
    public static final int LOADWORKFLOWSERVERERROR = 20;
    public static final int LOADRIGHTENGINEERROR = 21;
    public static final int LOADAPPLICATIONCONFIGERROR = 22;
    public static final int LOADAPPLICATIONCONFIGMAPPINGERROR = 23;
    public static final int LOADADMINSERVICEERROR = 24;
    public static final int UNSUPPORTSERVEREVENTERROR = 30;
    public static final int UNSUPPORTCOREPROCESSEVENTERROR = 31;
    public static final int UNSUPPORTCOREACTIVITYEVENTERROR = 32;
    public static final int UNSUPPORTPROCESSEVENTERROR = 33;
    public static final int UNSUPPORTACTIVITYEVENTERROR = 34;
    public static final int DISPATCHCOREPROCESSEVENTERROR = 35;
    public static final int DISPATCHCOREACTIVITYEVENTERROR = 36;
    public static final int APPLICATIONNOTFOUNDERROR = 100;
    public static final int NOTLOGINEDERROR = 200;
    public static final int ALREADYLOGINEDERROR = 201;
    public static final int PROCESSDEFINITIONERROR = 1000;
    public static final int ACTIVITYDEFINITIONERROR = 1001;
    public static final int ROUTEDEFINITIONERROR = 1002;
    public static final int GETPROCESSDEFLISTERROR = 1003;
    public static final int GETPROCESSINSTLISTERROR = 1004;
    public static final int GETACTIVITYINSTLISTERROR = 1005;
    public static final int CREATEPROCESSINSTANCEERROR = 2000;
    public static final int STARTPROCESSINSTANCEERROR = 2001;
    public static final int NEWPROCESSINSTANCEERROR = 2002;
    public static final int TRANSACTIONBEGINERROR = 100000;
    public static final int TRANSACTIONCOMMITERROR = 100001;
    public static final int TRANSACTIONROLLBACKERROR = 100002;
    public static final int FORMNOTFONUD = 9000;
    private Throwable cause;
    private int errorCode;

    public VFSException() {
    }

    public VFSException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    public VFSException(String message, Throwable cause, int errorCode) {
        this(message, cause);
        this.errorCode = errorCode;
    }

    public VFSException(String message) {
        super(message);
    }

    public VFSException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public VFSException(Throwable cause) {
        super(cause.toString());
        this.cause = cause;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public Throwable getException() {
        return this.cause;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            if (this.errorCode != 0) {
                ps.println("Error Code: " + this.errorCode);
            }
            super.printStackTrace(ps);
            if (this.cause != null) {
                ps.println("--- Nested Exception ---");
                this.cause.printStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            if (this.errorCode != 0) {
                pw.println("Error Code: " + this.errorCode);
            }
            super.printStackTrace(pw);
            if (this.cause != null) {
                pw.println("--- Nested Exception ---");
                this.cause.printStackTrace(pw);
            }
        }
    }
}

