/*
 * Decompiled with CFR 0.152.
 */
package com.ds.template;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSActionContext;
import com.ds.esb.util.EsbFactory;
import com.ds.jds.core.esb.util.ValueStack;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

public class JDSScopesHashModel
extends SimpleHash {
    private static final Log logger = LogFactory.getLog("esb", JDSScopesHashModel.class);
    private static final long serialVersionUID = 5551686380141886764L;
    private ValueStack stack;

    public JDSScopesHashModel(ObjectWrapper objectWrapper, ValueStack stack) {
        super(objectWrapper);
        this.stack = stack;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        TemplateModel model = super.get(key);
        try {
            if (model != null) {
                return model;
            }
            Object obj = null;
            if (key.startsWith("$")) {
                obj = EsbFactory.par(key, JDSActionContext.getActionContext().getContext(), null);
                if (obj != null) {
                    return this.wrap(obj);
                }
            } else {
                if (this.stack != null && (obj = (Object)this.stack.getContext().get(key)) == null) {
                    obj = this.stack.findValue(key);
                }
                if (obj == null) {
                    obj = JDSActionContext.getActionContext().getContext().get(key);
                }
                if (obj == null) {
                    obj = JDSActionContext.getActionContext().getParams(key);
                }
                if (obj != null) {
                    return this.wrap(obj);
                }
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return this.wrap("null");
    }
}

