/*
 * Decompiled with CFR 0.152.
 */
package com.ds.template;

import com.ds.config.JDSUtil;
import com.ds.context.JDSActionContext;
import com.ds.jds.core.esb.util.FileManager;
import com.ds.jds.core.esb.util.ValueStack;
import com.ds.template.JDSBeanWrapper;
import com.ds.template.JDSScopesHashModel;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDSFreemarkerManager {
    private static final Log log = LogFactory.getLog(JDSFreemarkerManager.class);
    public static final String CONFIG_SERVLET_CONTEXT_KEY = "freemarker.Configuration";
    public static final String KEY_EXCEPTION = "exception";
    public static final String KEY_APPLICATION = "Application";
    public static final String KEY_REQUEST_MODEL = "Request";
    public static final String KEY_SESSION_MODEL = "Session";
    public static final String KEY_JSP_TAGLIBS = "JspTaglibs";
    public static final String KEY_REQUEST_PARAMETER_MODEL = "Parameters";
    private String encoding = "utf-8";
    private boolean altMapWrapper;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setWrapperAltMap(String val) {
        this.altMapWrapper = "true".equals(val);
    }

    public final synchronized Configuration getConfiguration(String templatePath) throws TemplateException {
        Configuration config;
        if (templatePath == null) {
            try {
                templatePath = JDSUtil.getJdsRealPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((config = (Configuration)JDSActionContext.getActionContext().getContext().get(templatePath)) == null) {
            config = this.createConfiguration(templatePath);
            JDSActionContext.getActionContext().getContext().put(templatePath, config);
        }
        config.setWhitespaceStripping(true);
        return config;
    }

    protected JDSScopesHashModel buildScopesHashModel(ObjectWrapper wrapper, ValueStack stack) {
        JDSScopesHashModel model = new JDSScopesHashModel(wrapper, stack);
        return model;
    }

    protected TemplateLoader getTemplateLoader(String templatePath) {
        FileTemplateLoader templatePathLoader = null;
        try {
            if (templatePath == null) {
                templatePath = JDSUtil.getJdsRealPath();
            }
            if (templatePath != null) {
                templatePathLoader = new FileTemplateLoader(new File(templatePath));
            }
        }
        catch (IOException e) {
            log.error((Object)("Invalid template path specified: " + e.getMessage()), (Throwable)e);
        }
        return templatePathLoader;
    }

    protected Configuration createConfiguration(String templatePath) throws TemplateException {
        Configuration configuration = new Configuration();
        configuration.setTemplateLoader(this.getTemplateLoader(templatePath));
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        configuration.setObjectWrapper((ObjectWrapper)new JDSBeanWrapper(true));
        if (this.encoding != null) {
            configuration.setDefaultEncoding(this.encoding);
        }
        this.loadSettings(configuration);
        return configuration;
    }

    protected void loadSettings(Configuration configuration) {
        try {
            InputStream in = FileManager.loadFile("freemarker.properties", JDSFreemarkerManager.class);
            if (in != null) {
                Properties p = new Properties();
                p.load(in);
                configuration.setSettings(p);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while loading freemarker settings from /freemarker.properties", (Throwable)e);
        }
        catch (TemplateException e) {
            log.error((Object)"Error while loading freemarker settings from /freemarker.properties", (Throwable)e);
        }
    }

    public SimpleHash buildTemplateModel(ValueStack stack, ObjectWrapper wrapper) {
        JDSScopesHashModel model = this.buildScopesHashModel(wrapper, stack);
        return model;
    }
}

