/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server;

import com.ds.app.AppManager;
import com.ds.common.CommonConfig;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.config.JDSConfig;
import com.ds.config.UserBean;
import com.ds.context.JDSActionContext;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.org.OrgManager;
import com.ds.org.Permissions;
import com.ds.org.Person;
import com.ds.org.conf.OrgConstants;
import com.ds.server.LocalOrgManagerFactory;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;

public abstract class OrgManagerFactory {
    protected static Log log = LogFactory.getLog(OrgConstants.CONFIG_KEY.getType(), OrgManagerFactory.class);
    private static OrgManagerFactory factory = null;
    private static Map<ConfigCode, AppManager> appManagerMap = new HashMap<ConfigCode, AppManager>();
    public Map<String, SubSystem> systemMap = new HashMap<String, SubSystem>();
    public static ConcurrentMap<ConfigCode, OrgManager> orgManagerMap = new ConcurrentHashMap<ConfigCode, OrgManager>();
    private static Map<String, ScheduledExecutorService> threadPoolMap = new HashMap<String, ScheduledExecutorService>();
    public static final String THREAD_LOCK = "Thread Lock";
    private static ConfigCode DEFAULTSYSCODE = ConfigCode.org;

    public OrgManagerFactory() {
        if (this.systemMap.isEmpty()) {
            this.getSystems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized OrgManagerFactory getInstance() {
        if (factory != null) return factory;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (!UserBean.getInstance().getConfigName().equals(OrgConstants.CONFIG_KEY) && !UserBean.getInstance().getConfigName().equals(OrgConstants.CLUSTERCONFIG_KEY)) {
                factory = new LocalOrgManagerFactory();
            } else {
                Class c2;
                try {
                    c2 = ClassUtility.loadClass(CommonConfig.getValue(OrgConstants.ORGMANAGERFACTORYCLASSNAME_KEY));
                    factory = (OrgManagerFactory)c2.newInstance();
                }
                catch (Exception c2) {
                    // empty catch block
                }
                if (factory != null) return factory;
                try {
                    c2 = ClassUtility.loadClass("com.ds.common.org.impl.database.DbOrgManagerFactory");
                    factory = (OrgManagerFactory)c2.newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    public synchronized void reLoadSystem() {
        this.systemMap.clear();
        List<SubSystem> systems = this.getSystems();
    }

    public static final OrgManager getOrgManager() {
        ConfigCode subSystemId = JDSActionContext.getActionContext().getConfigCode();
        if (subSystemId == null) {
            subSystemId = DEFAULTSYSCODE;
        }
        return OrgManagerFactory.getOrgManager(subSystemId);
    }

    public final AppManager getAppManager(ConfigCode configCode) {
        AppManager appManager = appManagerMap.get(configCode);
        if (appManager == null) {
            appManager = EsbUtil.parExpression("$AppManager", AppManager.class);
            appManager.init(configCode);
            appManagerMap.put(configCode, appManager);
        }
        return appManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final OrgManager getClientOrgManager(ConfigCode configCode) {
        ConfigCode configCode2 = configCode;
        synchronized (configCode2) {
            OrgManager orgManager = null;
            try {
                String className = JDSConfig.getValue("OrgManager.implClassName");
                if (className == null) {
                    className = "com.ds.common.org.CtOrgManager";
                }
                Class c = ClassUtility.loadClass(className);
                orgManager = (OrgManager)c.newInstance();
            }
            catch (Exception ex1) {
                log.error("", ex1);
            }
            orgManager.init(configCode);
            return orgManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final OrgManager getOrgManager(ConfigCode subSystemId) {
        ConfigCode configCode = subSystemId;
        synchronized (configCode) {
            OrgManager orgManager;
            if (subSystemId == null) {
                subSystemId = JDSActionContext.getActionContext().getConfigCode();
            }
            if (subSystemId == null || subSystemId.equals("") || subSystemId.equals("\"\"")) {
                subSystemId = DEFAULTSYSCODE;
            }
            if ((orgManager = (OrgManager)orgManagerMap.get(subSystemId)) == null) {
                Class c;
                if (UserBean.getInstance().getConfigName().equals(ConfigCode.org)) {
                    c = null;
                    try {
                        c = ClassUtility.loadClass("com.ds.common.org.impl.database.DbOrgManagerImpl");
                        orgManager = (OrgManager)c.newInstance();
                    }
                    catch (Exception ex1) {
                        log.error("", ex1);
                    }
                } else {
                    try {
                        c = ClassUtility.loadClass(CommonConfig.getValue(DEFAULTSYSCODE.getType() + "." + "OrgManager.implClassName"));
                        orgManager = (OrgManager)c.newInstance();
                    }
                    catch (Exception ex) {
                        log.warn("Can't find OrgManager config in common_config!");
                        log.info("Try client config ...");
                        try {
                            String className = JDSConfig.getValue("OrgManager.implClassName");
                            if (className == null) {
                                className = "com.ds.common.org.CtOrgManager";
                            }
                            Class c2 = ClassUtility.loadClass(className);
                            orgManager = (OrgManager)c2.newInstance();
                        }
                        catch (Exception ex1) {
                            log.error("", ex1);
                        }
                    }
                }
                if (orgManager != null) {
                    try {
                        orgManager.init(subSystemId);
                        orgManagerMap.put(subSystemId, orgManager);
                    }
                    catch (Exception ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
            return orgManager;
        }
    }

    public OrgManager getOrgManagerByName(String name) {
        SubSystem system = this.systemMap.get(name);
        if (system == null) {
            return null;
        }
        return OrgManagerFactory.getOrgManager(system.getConfigname());
    }

    public OrgManager getOrgManagerByCode(String name) {
        if (this.systemMap.isEmpty() || this.systemMap.get(name) == null) {
            this.reLoadSystem();
        }
        SubSystem system = this.systemMap.get(name);
        return OrgManagerFactory.getOrgManager(system.getConfigname());
    }

    public abstract SubSystem getSystemById(String var1);

    public Map<String, SubSystem> getSystemMap() {
        return this.systemMap;
    }

    public abstract List<SubSystem> getSystems();

    public Permissions getPermissions(Person person) {
        return new Permissions();
    }
}

