/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ds.client.JDSSessionFactory;
import com.ds.cluster.ServerNode;
import com.ds.cluster.event.ClusterEventControl;
import com.ds.cluster.event.ServerEvent;
import com.ds.cluster.udp.ClusterClient;
import com.ds.cluster.udp.ClusterClientImpl;
import com.ds.common.JDSException;
import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheManager;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.cache.MemCacheManager;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.config.CApplication;
import com.ds.config.JDSConfig;
import com.ds.config.UserBean;
import com.ds.context.JDSActionContext;
import com.ds.engine.ConnectInfo;
import com.ds.engine.ConnectionHandle;
import com.ds.engine.DefaultConnectionHandle;
import com.ds.engine.JDSSessionHandle;
import com.ds.engine.event.EIServerEvent;
import com.ds.engine.event.EventControl;
import com.ds.engine.event.JDSEvent;
import com.ds.enums.ServerEventEnums;
import com.ds.esb.config.EsbBeanType;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.jds.core.User;
import com.ds.org.conf.OrgConstants;
import com.ds.server.Classpath;
import com.ds.server.JDSClientService;
import com.ds.server.JDSClientServiceImpl;
import com.ds.server.SessionCheckTask;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;
import com.ds.thread.JDSThreadFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javassist.ClassPool;
import javassist.NotFoundException;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.concurrent.FutureCallback;

public class JDSServer
implements Runnable {
    private static final Classpath classPath = new Classpath(System.getProperty("java.class.path"));
    private static final Log logger = LogFactory.getLog("JDS", JDSServer.class);
    private static final SerializeConfig config;
    static ExecutorService clearSensorservice;
    public static final ReadWriteLock lock;
    public static final String PRODUCT_NAME = "JDS Server";
    public static final String PRODUCT_VERSION = "V6.0b";
    public static final String PRODUCT_COPYRIGHT = "Copyright(c)2002 - 2020 itjds.net, All Rights Reserved";
    protected static final DateFormat dateFormat;
    private static final long DEFAULT_SESSIONCHECKINTERVAL = 300000L;
    private static final long DEFAULT_SESSIONEXPIRETIME = 1800000L;
    private static final int DEFAULT_UDPPORT = 8087;
    private static final String DEFAULT_UDPCODE = "utf-8";
    public static final String START_COMMAND = "START";
    public static final String STOP_COMMAND = "STOP";
    public static final String RESTART_COMMAND = "RESTART";
    public static final String STATUS_COMMAND = "STATUS";
    public static final String COMMAND_SUCCESS = "OK";
    public static final String COMMAND_FAIL = "FAIL";
    public static final String APPLICATION_ESBSYS_URL = "/api/sys/getClusterService";
    public static final String THREAD_LOCK = "Thread Lock";
    private static JDSServer instance;
    private static ClusterClient clusterClient;
    public static boolean started;
    private static ConcurrentMap<String, ConcurrentMap<ConfigCode, JDSClientService>> clientServiceMap;
    private static Cache<String, ConnectInfo> sessionhandleConnectInfoCache;
    private static Cache<String, String> sessionhandleSystemCodeCache;
    private static Cache<String, JDSSessionHandle> sessionHandleCache;
    private static Cache<String, String> connectHandleCache;
    protected static Cache<String, Long> connectTimeCache;
    private ServerSocket serverSocket;
    private Thread serverThread;
    protected boolean serverRunning = true;
    long expireTime = 0L;

    private JDSServer() throws JDSException {
        this.init();
        this.getClusterClient().start();
        this._start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JDSServer getInstance() throws JDSException {
        if (instance != null) return instance;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (instance != null) return instance;
            instance = new JDSServer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<ExpressionTempBean> getClusterSevice() throws JDSException {
        ArrayList<ExpressionTempBean> clusterSeviceList = new ArrayList();
        if (!UserBean.getInstance().getConfigName().equals(OrgConstants.CLUSTERCONFIG_KEY)) {
            clusterSeviceList = this.getRemoteClusterSevice();
        } else {
            List<EsbBean> esbBeanList = EsbBeanFactory.getInstance().getEsbBeanList();
            for (EsbBean esbBean : esbBeanList) {
                if (esbBean.getEsbtype() == null || !esbBean.getEsbtype().equals(EsbBeanType.Cluster)) continue;
                List<? extends ServiceBean> list = EsbBeanFactory.getInstance().getAllServiceBeanByEsbKey(esbBean.getId());
                for (ServiceBean serviceBean : list) {
                    if (!(serviceBean instanceof ExpressionTempBean)) continue;
                    if (serviceBean.getFlowType() != null) {
                        ((ExpressionTempBean)serviceBean).setFlowType(EsbFlowType.remoteAction);
                    }
                    clusterSeviceList.add((ExpressionTempBean)serviceBean);
                }
            }
        }
        return clusterSeviceList;
    }

    private List<ExpressionTempBean> getRemoteClusterSevice() throws JDSException {
        List<ExpressionTempBean> tempBeanList;
        block4: {
            String url = APPLICATION_ESBSYS_URL;
            Request request = Request.Post((String)(UserBean.getInstance().getServerUrl() + url));
            Future future = Async.newInstance().execute(request, (FutureCallback)new FutureCallback<Content>(){

                public void failed(Exception ex) {
                    ex.printStackTrace();
                }

                public void completed(Content content) {
                }

                public void cancelled() {
                }
            });
            tempBeanList = new ArrayList();
            String json = "";
            try {
                json = ((Content)future.get()).asString();
                JSONObject jsonObj = JSONObject.parseObject((String)json);
                Integer status = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
                if (status == 0) {
                    String data = jsonObj.getString("data");
                    tempBeanList = JSONArray.parseArray((String)data, ExpressionTempBean.class);
                    for (ExpressionTempBean tempBean : tempBeanList) {
                        if (tempBean.getFlowType() == null) continue;
                        tempBean.setFlowType(EsbFlowType.remoteAction);
                    }
                    break block4;
                }
                throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\uff01");
            }
            catch (Exception e) {
                throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\uff01");
            }
        }
        return tempBeanList;
    }

    void startUDPServer() {
        String code;
        String enable = JDSConfig.getValue("udpServer.enabled");
        String portStr = JDSConfig.getValue("udpServer.port");
        int port = 8087;
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException nfe) {
                port = 8087;
            }
        }
        if ((code = JDSConfig.getValue("udpServer.code")) == null) {
            code = DEFAULT_UDPCODE;
        }
        logger.info("************************************************");
        logger.info("canable udpServer :" + enable);
        if (enable != null && Boolean.valueOf(enable).booleanValue()) {
            Executors.newSingleThreadExecutor(new JDSThreadFactory("JDSServer.startUDPServer")).execute(new Runnable(){

                @Override
                public void run() {
                    logger.info("start clearCache ");
                    JDSServer.this.clearCache();
                }
            });
        }
    }

    private void init() throws JDSException {
        String expireTimeStr = JDSConfig.getValue("session.ExpireTime");
        if (expireTimeStr == null) {
            this.expireTime = 1800000L;
        } else {
            try {
                this.expireTime = (long)(Double.parseDouble(expireTimeStr) * 60000.0);
            }
            catch (NumberFormatException nfe) {
                this.expireTime = 1800000L;
            }
        }
        sessionhandleConnectInfoCache = CacheManagerFactory.createCache("JDS", "SessionhandleConnectInfo", 0xA00000, 86400000L);
        sessionhandleSystemCodeCache = CacheManagerFactory.createCache("JDS", "SessionhandleSystemCodeCache", 0xA00000, 86400000L);
        sessionHandleCache = CacheManagerFactory.createCache("JDS", "SessionHandle", 0xA00000, 86400000L);
        connectHandleCache = CacheManagerFactory.createCache("JDS", "ConnectHandleCache", 0xA00000, 86400000L);
        connectTimeCache = CacheManagerFactory.createCache("JDS", "ConnectTimeCache", 0xA00000, 86400000L);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        long startTime = System.currentTimeMillis();
        logger.info("JDS Server - V6.0b");
        logger.info(PRODUCT_COPYRIGHT);
        logger.info("************************************************");
        logger.info("-------- JDSServer Initialization ---------");
        logger.info("************************************************");
        logger.info("JDS Home: " + JDSConfig.Config.currServerHome().getAbsolutePath());
        boolean isloaddb = true;
        try {
            isloaddb = new Boolean(JDSConfig.getValue("loaddb"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventControl ec = EventControl.getInstance();
        for (int i = 0; i < ec.coreServerEventListeners.size(); ++i) {
            logger.info("Load ServerEventListener: " + ec.coreServerEventListeners.get(i).getClass().getName());
        }
        boolean sessionCheckEnabled = true;
        try {
            sessionCheckEnabled = new Boolean(JDSConfig.getValue("session.enabled"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sessionCheckEnabled) {
            long checkInterval;
            String checkIntervalStr = JDSConfig.getValue("session.CheckInterval");
            if (checkIntervalStr == null) {
                checkInterval = 300000L;
            } else {
                try {
                    checkInterval = (long)(Double.parseDouble(checkIntervalStr) * 60000.0);
                }
                catch (NumberFormatException nfe) {
                    checkInterval = 300000L;
                }
            }
            SessionCheckTask sessionCheckTask = new SessionCheckTask(this.expireTime);
            Executors.newSingleThreadScheduledExecutor(new JDSThreadFactory("JDSServer.sessionCheckTask")).scheduleWithFixedDelay(sessionCheckTask, 15000L, checkInterval, TimeUnit.MILLISECONDS);
        }
        if (JDSConfig.Config.startAdminThread()) {
            try {
                this.startListenerThread();
                this.setShutdownHook();
            }
            catch (IOException ioe) {
                throw new JDSException(" admin thread start failed.", ioe, 11);
            }
        }
        long timeCost = System.currentTimeMillis() - startTime;
        logger.info("************************************************");
        logger.info("----- DataBase Initialized in " + timeCost / 1000L + "s:" + timeCost % 1000L + " -----");
        startTime = System.currentTimeMillis();
        this.startUDPServer();
        long timeLoadUDP = System.currentTimeMillis() - startTime;
        logger.info("----- UDPServer Initialized in " + timeLoadUDP / 1000L + "s:" + timeLoadUDP % 1000L + " -----");
        startTime = System.currentTimeMillis();
        long timeLoadOrg = System.currentTimeMillis() - startTime;
        logger.info("----- Load Org in " + timeLoadOrg / 1000L + "s:" + timeLoadOrg % 1000L + " -----");
        logger.info("************************************************");
    }

    private void destroy() {
    }

    private void _start() throws JDSException {
        if (!started) {
            logger.info("JDS Server starting ...");
            EIServerEvent serverStartingEvent = new EIServerEvent(ServerEventEnums.serverStarting);
            EventControl.getInstance().dispatchEvent((JDSEvent)serverStartingEvent);
            logger.info("JDS Server loadLibs ...");
            JDSServer.loadLibs(JDSConfig.Config.applicationHome());
            logger.info("JDS Server setProperty ...");
            System.setProperty("java.class.path", classPath.toString());
            String currSystemCode = UserBean.getInstance().getSystemCode();
            logger.info("Classpath: " + classPath);
            logger.info("JDS Server opened for business.");
            started = true;
            EIServerEvent serverStartedEvent = new EIServerEvent(ServerEventEnums.serverStarted);
            EventControl.getInstance().dispatchEvent((JDSEvent)serverStartedEvent);
        }
    }

    private void _stop() throws JDSException {
        if (started) {
            logger.info("JDS Server stopping ...");
            EIServerEvent serverStoppingEvent = new EIServerEvent(ServerEventEnums.serverStopped);
            EventControl.getInstance().dispatchEvent((JDSEvent)serverStoppingEvent);
            HashMap evetntContext = new HashMap();
            SubSystem system = JDSServer.getClusterClient().getSystem(this.getCurrServerBean().getId());
            this.fireSeverEvent(system, ServerEventEnums.serverStarting, evetntContext);
            Iterator ite = connectTimeCache.keySet().iterator();
            while (ite.hasNext()) {
                JDSSessionHandle handle = (JDSSessionHandle)this.getSessionHandleCache().get(ite.next());
                this.invalidateSession(handle, false);
            }
        }
        Map cacheManagerMap = CacheManagerFactory.getInstance().getCacheManagerMap();
        for (String key : cacheManagerMap.keySet()) {
            CacheManager cacheManager = (CacheManager)cacheManagerMap.get(key);
            if (!cacheManager.isCacheEnabled() || !(cacheManager instanceof MemCacheManager)) continue;
            Map cacheMap = cacheManager.getAllCache();
            for (String cacheName : cacheMap.keySet()) {
                Cache cache = (Cache)cacheMap.get(cacheName);
                cache.clear();
            }
            logger.info("Cache destroyed");
        }
        logger.info("JDS Server start stopped.");
        started = false;
        EIServerEvent serverStoppedEvent = new EIServerEvent(ServerEventEnums.serverStopped);
        EventControl.getInstance().dispatchEvent((JDSEvent)serverStoppedEvent);
        HashMap evetntContext = new HashMap();
        SubSystem system = JDSServer.getClusterClient().getSystem(this.getCurrServerBean().getId());
        this.fireSeverEvent(system, ServerEventEnums.serverStopped, evetntContext);
        logger.info("JDS Server stopped.");
    }

    private void _restart() throws JDSException {
        this._stop();
        this._start();
    }

    private DatabaseMetaData getDatabaseMetaData(Connection connection) {
        if (connection == null) {
            return null;
        }
        DatabaseMetaData dbData = null;
        try {
            dbData = connection.getMetaData();
        }
        catch (SQLException sqle) {
            logger.error("Unable to get database meta data... Error was:" + sqle.toString());
            return null;
        }
        if (dbData == null) {
            logger.error("Unable to get database meta data; method returned null");
        }
        return dbData;
    }

    private void printDbMiscData(DatabaseMetaData dbData) {
        if (dbData == null) {
            return;
        }
        if (logger.isInfoEnabled()) {
            try {
                logger.info("Database Product Name is " + dbData.getDatabaseProductName());
                logger.info("Database Product Version is " + dbData.getDatabaseProductVersion());
            }
            catch (SQLException sqle) {
                logger.warn("Unable to get Database name & version information");
            }
        }
        if (logger.isInfoEnabled()) {
            try {
                logger.info("Database Driver Name is " + dbData.getDriverName());
                logger.info("Database Driver Version is " + dbData.getDriverVersion());
            }
            catch (SQLException sqle) {
                logger.warn("Unable to get Driver name & version information");
            }
        }
        if (logger.isInfoEnabled()) {
            try {
                logger.info("- supports transactions    [" + dbData.supportsTransactions() + "]*");
                logger.info("- isolation None           [" + dbData.supportsTransactionIsolationLevel(0) + "]");
                logger.info("- isolation ReadCommitted  [" + dbData.supportsTransactionIsolationLevel(2) + "]");
                logger.info("- isolation ReadUncommitted[" + dbData.supportsTransactionIsolationLevel(1) + "]");
                logger.info("- isolation RepeatableRead [" + dbData.supportsTransactionIsolationLevel(4) + "]");
                logger.info("- isolation Serializable   [" + dbData.supportsTransactionIsolationLevel(8) + "]");
                logger.info("- is case sensitive        [" + dbData.supportsMixedCaseIdentifiers() + "]");
                logger.info("- stores LowerCase         [" + dbData.storesLowerCaseIdentifiers() + "]");
                logger.info("- stores MixedCase         [" + dbData.storesMixedCaseIdentifiers() + "]");
                logger.info("- stores UpperCase         [" + dbData.storesUpperCaseIdentifiers() + "]");
                logger.info("- max table name length    [" + dbData.getMaxTableNameLength() + "]");
                logger.info("- max column name length   [" + dbData.getMaxColumnNameLength() + "]");
                logger.info("- max schema name length   [" + dbData.getMaxSchemaNameLength() + "]");
                logger.info("- concurrent connections   [" + dbData.getMaxConnections() + "]");
                logger.info("- concurrent statements    [" + dbData.getMaxStatements() + "]");
                logger.info("- ANSI SQL92 Entry         [" + dbData.supportsANSI92EntryLevelSQL() + "]");
                logger.info("- ANSI SQL92 Itermediate   [" + dbData.supportsANSI92IntermediateSQL() + "]");
                logger.info("- ANSI SQL92 Full          [" + dbData.supportsANSI92FullSQL() + "]");
                logger.info("- ODBC SQL Grammar Core    [" + dbData.supportsCoreSQLGrammar() + "]");
                logger.info("- ODBC SQL Grammar Extended[" + dbData.supportsExtendedSQLGrammar() + "]");
                logger.info("- ODBC SQL Grammar Minimum [" + dbData.supportsMinimumSQLGrammar() + "]");
                logger.info("- outer joins              [" + dbData.supportsOuterJoins() + "]*");
                logger.info("- limited outer joins      [" + dbData.supportsLimitedOuterJoins() + "]");
                logger.info("- full outer joins         [" + dbData.supportsFullOuterJoins() + "]");
                logger.info("- group by                 [" + dbData.supportsGroupBy() + "]*");
                logger.info("- group by not in select   [" + dbData.supportsGroupByUnrelated() + "]");
                logger.info("- column aliasing          [" + dbData.supportsColumnAliasing() + "]");
                logger.info("- order by not in select   [" + dbData.supportsOrderByUnrelated() + "]");
                logger.info("- alter table add column   [" + dbData.supportsAlterTableWithAddColumn() + "]*");
                logger.info("- non-nullable column      [" + dbData.supportsNonNullableColumns() + "]*");
            }
            catch (Exception e) {
                logger.warn("Unable to get misc. support/setting information");
            }
        }
    }

    public JDSClientService newJDSClientService(JDSSessionHandle sessionHandle, ConfigCode configCode) throws JDSException {
        if (!started) {
            throw new JDSException("JDSServer not started!", 10);
        }
        if (configCode == null) {
            throw new JDSException("systemCode is null!", 10);
        }
        JDSClientServiceImpl jdsService = null;
        ConnectionHandle handle = null;
        CApplication app = this.getClusterClient().getApplication(configCode);
        if (app == null) {
            jdsService = new JDSClientServiceImpl(sessionHandle, configCode);
            if (jdsService.getConnectInfo() != null) {
                this.connect(jdsService);
            }
        } else {
            Object[] parms;
            Class clazz;
            if (app.getJdsService() != null) {
                String jdsServiceStr = app.getJdsService().getImplementation();
                try {
                    clazz = ClassUtility.loadClass(jdsServiceStr);
                    parms = new Object[2];
                    ConnectInfo connectInfo = this.getConnectInfo(sessionHandle);
                    parms[0] = connectInfo;
                    parms[1] = configCode;
                    Constructor constructor = clazz.getConstructor(ConnectInfo.class, ConfigCode.class);
                    JDSClientService jDSClientService = (JDSClientService)constructor.newInstance(parms);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new JDSException("JDSClientService class '" + jdsServiceStr + "' not found.", cnfe, 21);
                }
                catch (IllegalAccessException iae) {
                    throw new JDSException("", iae, 21);
                }
                catch (InstantiationException ie) {
                    throw new JDSException("", ie, 21);
                }
                catch (ClassCastException cce) {
                    throw new JDSException(jdsServiceStr + " must implement " + JDSClientService.class + " interface.", cce, 21);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                jdsService = new JDSClientServiceImpl(sessionHandle, configCode);
                ConnectInfo connectInfo = this.getConnectInfo(sessionHandle);
                if (jdsService.getConnectInfo() != null) {
                    this.connect(jdsService);
                }
            }
            if (app.getConnectionHandle() != null) {
                String connectionHandleStr = app.getConnectionHandle().getImplementation();
                try {
                    clazz = ClassUtility.loadClass(connectionHandleStr);
                    parms = new Object[]{jdsService, sessionHandle, jdsService.getSystemCode()};
                    Constructor constructor = clazz.getConstructor(JDSClientService.class, JDSSessionHandle.class, String.class);
                    handle = (ConnectionHandle)constructor.newInstance(parms);
                }
                catch (Exception e) {
                    handle = new DefaultConnectionHandle(jdsService, sessionHandle, configCode);
                }
            } else {
                handle = new DefaultConnectionHandle(jdsService, sessionHandle, configCode);
            }
        }
        jdsService.setConnectionHandle(handle);
        return jdsService;
    }

    public boolean isCometServer() {
        return EsbBeanFactory.getInstance().getIdMap().containsKey("RepeatCommand");
    }

    public JDSClientService getJDSClientService(JDSSessionHandle sessionHandle, ConfigCode configCode) throws JDSException {
        if (!started) {
            throw new JDSException("JDSServer not started!", 10);
        }
        if (sessionHandle == null) {
            throw new JDSException("Session invalid error!", 200);
        }
        ConcurrentHashMap<ConfigCode, JDSClientService> clients = (ConcurrentHashMap<ConfigCode, JDSClientService>)clientServiceMap.get(sessionHandle.getSessionID());
        JDSClientService clientService = null;
        if (clients == null) {
            clients = new ConcurrentHashMap<ConfigCode, JDSClientService>();
        }
        if (configCode == null) {
            configCode = OrgConstants.CLUSTERCONFIG_KEY;
        }
        if (!clients.containsKey(configCode)) {
            clientService = this.newJDSClientService(sessionHandle, configCode);
            if (configCode.equals(this.getCurrServerBean().getId())) {
                try {
                    this.connect(clientService);
                }
                catch (JDSException jDSException) {
                    // empty catch block
                }
            }
            clients.put(configCode, clientService);
            clientServiceMap.put(sessionHandle.getSessionID(), clients);
        } else {
            clientService = (JDSClientService)clients.get(configCode);
        }
        return clientService;
    }

    public static void activeSession(JDSSessionHandle sessionHandle) {
        connectTimeCache.put(sessionHandle.getSessionID(), System.currentTimeMillis());
        sessionHandleCache.put(sessionHandle.getSessionID(), sessionHandle);
    }

    public void invalidateSession(List<JDSSessionHandle> sessionHandleList) {
        for (int i = 0; i < sessionHandleList.size(); ++i) {
            final JDSSessionHandle sessionHandle = sessionHandleList.get(i);
            clearSensorservice.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread().setName("disconnect " + sessionHandle);
                        JDSServer.getInstance().disconnect(sessionHandle);
                    }
                    catch (JDSException e) {
                        JDSServer.this.invalidateSession(sessionHandle, true);
                    }
                }
            });
        }
    }

    private void invalidateSession(JDSSessionHandle sessionHandle, boolean msgClient) {
        if (sessionHandle == null) {
            return;
        }
        clientServiceMap.remove(sessionHandle.getSessionID());
        connectTimeCache.remove(sessionHandle.getSessionID());
        sessionHandleCache.remove(sessionHandle.getSessionID());
        ConnectInfo connectInfo = (ConnectInfo)sessionhandleConnectInfoCache.get(sessionHandle.getSessionID());
        if (connectInfo == null) {
            return;
        }
        Set<JDSSessionHandle> sessionHandleList = this.getJDSSessionHandlist(connectInfo);
        if (sessionHandleList != null && sessionHandleList.contains(sessionHandle)) {
            sessionHandleList.remove(sessionHandle);
            this.updateHandle(connectInfo, sessionHandleList);
        }
        sessionhandleConnectInfoCache.remove(sessionHandle.getSessionID());
        logger.debug("Invalidate Session for user '" + connectInfo.getLoginName() + "'");
    }

    public Set<JDSSessionHandle> getJDSSessionHandlist(ConnectInfo connectInfo) {
        String handleList = (String)connectHandleCache.get(connectInfo.getUserID());
        LinkedHashSet<JDSSessionHandle> realSessionHandle = new LinkedHashSet<JDSSessionHandle>();
        List sessionHandleList = null;
        if (handleList != null) {
            sessionHandleList = JSONArray.parseArray((String)handleList, JDSSessionHandle.class);
            for (JDSSessionHandle handle : sessionHandleList) {
                if (handle == null || this.getSessionHandleCache().get(handle.getSessionID()) == null) continue;
                realSessionHandle.add((JDSSessionHandle)this.getSessionHandleCache().get(handle.getSessionID()));
            }
        }
        return realSessionHandle;
    }

    public void updateHandle(ConnectInfo connectInfo, Set<JDSSessionHandle> sessionHandleList) {
        String json = JSONArray.toJSONString(sessionHandleList, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
        connectHandleCache.put(connectInfo.getUserID(), json);
    }

    public JDSSessionHandle connect(JDSClientService clientService) throws JDSException {
        ConcurrentHashMap<ConfigCode, JDSClientService> clients;
        if (!started) {
            throw new JDSException("JDSServer not started!", 10);
        }
        JDSSessionHandle sessionHandle = clientService.getSessionHandle();
        ConnectInfo connectInfo = clientService.getConnectInfo();
        if (sessionHandle == null) {
            throw new JDSException("sessionHandle  is null", 200);
        }
        if (connectInfo == null && (connectInfo = (ConnectInfo)sessionhandleConnectInfoCache.get(sessionHandle.getSessionID())) != null) {
            clientService.connect(connectInfo);
        }
        if (connectInfo == null && clientService.getConnectionHandle() != null && (connectInfo = clientService.getConnectionHandle().getConnectInfo()) != null) {
            clientService.connect(connectInfo);
        }
        if (connectInfo == null) {
            throw new JDSException("connectInfo  is null", 200);
        }
        Set<JDSSessionHandle> sessionHandleList = this.getJDSSessionHandlist(connectInfo);
        if (JDSConfig.Config.singleLogin() && sessionHandleList != null && sessionHandleList.size() != 0 && !sessionHandleList.contains(sessionHandle)) {
            throw new JDSException("User '" + connectInfo.getLoginName() + "' already logined!", 201);
        }
        ConfigCode configCode = clientService.getConfigCode();
        if (sessionHandleList == null) {
            sessionHandleList = new LinkedHashSet<JDSSessionHandle>();
        }
        if (sessionHandleList.contains(sessionHandle)) {
            clients = (ConcurrentHashMap<ConfigCode, JDSClientService>)clientServiceMap.get(sessionHandle.getSessionID());
            if (clients == null) {
                clients = new ConcurrentHashMap<ConfigCode, JDSClientService>();
                clientServiceMap.put(sessionHandle.getSessionID(), (ConcurrentMap<ConfigCode, JDSClientService>)clients);
            }
            clients.put(configCode, clientService);
        } else {
            this.invalidateSession(sessionHandle, false);
            sessionHandleList.add(sessionHandle);
            clients = new ConcurrentHashMap();
            clients.put(configCode, clientService);
            clientServiceMap.put(sessionHandle.getSessionID(), clients);
            this.updateHandle(connectInfo, sessionHandleList);
            sessionHandleCache.put(sessionHandle.getSessionID(), sessionHandle);
            sessionhandleConnectInfoCache.put(sessionHandle.getSessionID(), connectInfo);
        }
        JDSActionContext.getActionContext().getSession().put("JDSUSERID", connectInfo.getUserID());
        if (JDSActionContext.getActionContext().getSessionId() == null) {
            JDSActionContext.getActionContext().getSession().put("JSESSIONID", clientService.getSessionHandle().getSessionID());
        }
        long currentTime = System.currentTimeMillis();
        connectTimeCache.put(sessionHandle.getSessionID(), currentTime);
        if (this.isCometServer()) {
            JDSServer.getSessionhandleSystemCodeCache().put(sessionHandle.getSessionID(), JDSServer.getInstance().getCurrServerBean().getId());
        }
        return sessionHandle;
    }

    public void disconnect(JDSSessionHandle sessionHandle) throws JDSException {
        if (!started) {
            throw new JDSException("JDSServer not started!", 10);
        }
        ConnectInfo connectInfo = this.getConnectInfo(sessionHandle);
        this.invalidateSession(sessionHandle, true);
        long currentTime = System.currentTimeMillis();
        if (connectInfo != null) {
            logger.info("User '" + connectInfo.getLoginName() + "' logout at " + dateFormat.format(new Date(currentTime)) + ".");
        }
    }

    public static void start() throws JDSException {
        try {
            JDSServer.sendSocketCommand(START_COMMAND);
        }
        catch (IOException ioe) {
            throw new JDSException("jds Server START command error.", ioe, 15);
        }
    }

    public static String status() throws JDSException {
        try {
            return JDSServer.sendSocketCommand(STATUS_COMMAND);
        }
        catch (ConnectException e) {
            return "Connect to server failed.";
        }
        catch (IOException e) {
            throw new JDSException("jds Server STATUS command error.", e, 14);
        }
    }

    public static String stop() throws JDSException {
        try {
            return JDSServer.sendSocketCommand(STOP_COMMAND);
        }
        catch (IOException ioe) {
            throw new JDSException("jds Server STOP command error.", ioe, 16);
        }
    }

    public static String restart() throws JDSException {
        try {
            return JDSServer.sendSocketCommand(RESTART_COMMAND);
        }
        catch (IOException ioe) {
            throw new JDSException("JDS Server RESTART command error.", ioe, 17);
        }
    }

    public boolean started() {
        return started;
    }

    @Override
    public void run() {
        while (this.serverRunning) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                logger.info("Received connection from - " + clientSocket.getInetAddress() + " : " + clientSocket.getPort());
                this.processClientRequest(clientSocket);
                clientSocket.close();
            }
            catch (IOException e) {
                logger.error("", e);
            }
        }
    }

    private void startListenerThread() throws IOException {
        try {
            this.serverSocket = new ServerSocket(JDSConfig.Config.adminPort(), 1, JDSConfig.Config.adminAddress());
            this.serverThread = new Thread((Runnable)this, this.toString());
            this.serverThread.setDaemon(false);
            this.serverThread.start();
            logger.info("Startup admin listener thread [" + JDSConfig.Config.adminAddress().getHostName() + ":" + JDSConfig.Config.adminPort() + "]");
        }
        catch (BindException bindException) {
            // empty catch block
        }
    }

    private void processClientRequest(Socket client) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
        String request = reader.readLine();
        PrintWriter writer = new PrintWriter(client.getOutputStream(), true);
        writer.println(this.processRequest(request, client));
        writer.flush();
        writer.close();
        reader.close();
    }

    private String processRequest(String request, Socket client) {
        if (request != null) {
            String key = request.substring(0, request.indexOf(58));
            String command = request.substring(request.indexOf(58) + 1);
            if (!key.equals(JDSConfig.Config.adminKey())) {
                return "Admin key ERROR";
            }
            logger.trace("Command '" + command + "' issued from: " + client.getInetAddress().getHostAddress() + ":" + client.getPort());
            if (command.equals(START_COMMAND)) {
                try {
                    this._start();
                    return COMMAND_SUCCESS;
                }
                catch (JDSException e) {
                    logger.error("Command '" + command + "' failed.", e);
                    return COMMAND_FAIL;
                }
            }
            if (command.equals(STOP_COMMAND)) {
                try {
                    this._stop();
                    return COMMAND_SUCCESS;
                }
                catch (JDSException e) {
                    logger.error("Command '" + command + "' failed.", e);
                    return COMMAND_FAIL;
                }
            }
            if (command.equals(RESTART_COMMAND)) {
                try {
                    this._restart();
                    return COMMAND_SUCCESS;
                }
                catch (JDSException e) {
                    logger.error("Command '" + command + "' failed.", e);
                    return COMMAND_FAIL;
                }
            }
            if (command.equals(STATUS_COMMAND)) {
                return started ? "Running" : "Stopped";
            }
            return "Unknown Command";
        }
        return COMMAND_FAIL;
    }

    private static void loadLibs(File libDir) {
        File[] files;
        if (libDir.exists() && libDir.isDirectory() && (files = libDir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i].getName();
                if (files[i].isDirectory()) {
                    JDSServer.loadLibs(files[i]);
                    continue;
                }
                if (!fileName.endsWith(".jar") && !fileName.endsWith(".zip") && !fileName.endsWith(".class")) continue;
                classPath.addComponent(files[i]);
            }
        }
    }

    private static void initPoolClassPah(File libDir) {
        try {
            ClassPool pool = ClassPool.getDefault();
            String absolutePath = JDSConfig.getAbsolutePath("", null);
            if (absolutePath != null) {
                pool.appendClassPath(absolutePath);
            }
            logger.info("absolutePath= " + absolutePath);
            File jarFile = new File(absolutePath + File.separator + ".." + File.separator + ".." + File.separator + "WEB-INF" + File.separator + "lib");
            logger.info("initPoolClassPah =" + jarFile.getAbsolutePath());
            if (!jarFile.exists() && libDir.exists() && libDir.getParentFile() != null && libDir.getParentFile().getParentFile() != null) {
                jarFile = new File(libDir.getParentFile().getParentFile().getAbsolutePath() + File.separator + "WEB-INF" + File.separator + "lib");
            }
            if (jarFile.exists() && jarFile.isDirectory()) {
                File[] files = jarFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i].getName();
                    if (!fileName.endsWith(".jar") && !fileName.endsWith(".zip")) continue;
                    pool.appendClassPath(files[i].getPath());
                }
            }
        }
        catch (NotFoundException e1) {
            e1.printStackTrace();
        }
    }

    private static String sendSocketCommand(String command) throws IOException, ConnectException {
        Socket socket = new Socket(JDSConfig.Config.adminAddress(), JDSConfig.Config.adminPort());
        PrintWriter writer = new PrintWriter(socket.getOutputStream(), true);
        writer.println(JDSConfig.Config.adminKey() + ":" + command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String response = null;
        try {
            for (int tryCounts = 0; !reader.ready() && tryCounts < 5; ++tryCounts) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (reader.ready()) {
            response = reader.readLine();
        }
        reader.close();
        writer.close();
        socket.close();
        return response;
    }

    private void setShutdownHook() {
        try {
            Method shutdownHook = Runtime.class.getMethod("addShutdownHook", Thread.class);
            Thread hook = new Thread(){

                @Override
                public void run() {
                    this.setName("JDS_Shutdown_Hook");
                    JDSServer.this.serverRunning = false;
                    JDSServer.this.destroy();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            shutdownHook.invoke((Object)Runtime.getRuntime(), hook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set<JDSSessionHandle> getSessionHandleList(ConnectInfo connectInfo) {
        LinkedHashSet<JDSSessionHandle> sessionHandleList = new LinkedHashSet<JDSSessionHandle>();
        Set<JDSSessionHandle> serverHandleList = this.getJDSSessionHandlist(connectInfo);
        if (serverHandleList != null) {
            for (JDSSessionHandle handle : serverHandleList) {
                if (this.expireTime > 0L) {
                    long currentTime = System.currentTimeMillis();
                    Long loginTime = (Long)this.getConnectTimeCache().get(handle.getSessionID());
                    if (loginTime == null || currentTime - loginTime >= this.expireTime) continue;
                    sessionHandleList.add(handle);
                    continue;
                }
                sessionHandleList.add(handle);
            }
        }
        return sessionHandleList;
    }

    public Map<String, Map<ConfigCode, JDSClientService>> getClientServiceMap() {
        HashMap<String, Map<ConfigCode, JDSClientService>> clientMap = new HashMap<String, Map<ConfigCode, JDSClientService>>();
        clientMap.putAll(clientServiceMap);
        return clientMap;
    }

    public Cache<String, Long> getConnectTimeCache() {
        return connectTimeCache;
    }

    public ConnectInfo getConnectInfo(JDSSessionHandle handle) {
        ConnectInfo connectInfo = (ConnectInfo)sessionhandleConnectInfoCache.get(handle.getSessionID());
        return connectInfo;
    }

    public static List<ConnectInfo> getAllConnectInfo() {
        ArrayList<ConnectInfo> infoList = new ArrayList<ConnectInfo>();
        List connectInfos = (List)sessionhandleConnectInfoCache.values();
        for (ConnectInfo connectInfo : connectInfos) {
            if (infoList.contains(connectInfo)) continue;
            infoList.add(connectInfo);
        }
        return infoList;
    }

    public Cache<String, JDSSessionHandle> getSessionHandleCache() {
        return sessionHandleCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterClient getClusterClient() {
        if (clusterClient != null) return clusterClient;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (clusterClient != null) return clusterClient;
            clusterClient = new ClusterClientImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return clusterClient;
        }
    }

    public static Cache<String, String> getSessionhandleSystemCodeCache() {
        return sessionhandleSystemCodeCache;
    }

    public User getAdminUser() {
        return JDSServer.getClusterClient().getUDPClient().getUser();
    }

    public JDSClientService getAdminClient() throws JDSException {
        JDSClientService client;
        User user = this.getAdminUser();
        String adminId = user.getSessionId();
        JDSSessionHandle handle = (JDSSessionHandle)this.getSessionHandleCache().get(adminId);
        if (handle == null) {
            handle = JDSSessionFactory.newSessionHandle(adminId);
        }
        if ((client = JDSServer.getInstance().getJDSClientService(handle, user.getConfigName())).getConnectInfo() == null || !client.getConnectInfo().getLoginName().equals(user.getName())) {
            client.connect(new ConnectInfo(user.getId(), user.getName(), user.getPassword()));
        }
        return client;
    }

    public ServerNode getCurrServerBean() {
        String currSystemCode = UserBean.getInstance().getSystemCode();
        ServerNode currServerBean = JDSServer.getClusterClient().getServerNodeById(currSystemCode);
        if (currServerBean == null) {
            logger.error("************************************************");
            logger.error("System error!");
            logger.error("System error! CurrSystem [" + currSystemCode + "] not registers in cluster!");
            logger.error("custerServer URL is " + UserBean.getInstance().getServerUrl());
            logger.error("place register  is frist!");
            logger.error("************************************************");
        }
        return currServerBean;
    }

    public CApplication getCurrApplication() {
        String currSystemCode = UserBean.getInstance().getSystemCode();
        ServerNode currServerBean = JDSServer.getClusterClient().getServerNodeById(currSystemCode);
        SubSystem system = JDSServer.getClusterClient().getSystem(currServerBean.getId());
        CApplication application = JDSServer.getClusterClient().getApplication(system.getConfigname());
        application.setSysId(system.getSysId());
        if (application == null) {
            logger.error("************************************************");
            logger.error("Confit error!");
            logger.error("System error! CurrSystem [" + currSystemCode + "] not registers in cluster!");
            logger.error("custerServer URL is " + UserBean.getInstance().getServerUrl());
            logger.error("place register  is frist!");
            logger.error("************************************************");
        }
        return application;
    }

    public void clearCache() {
        sessionhandleConnectInfoCache.clear();
        sessionhandleSystemCodeCache.clear();
        sessionHandleCache.clear();
        connectHandleCache.clear();
        connectTimeCache.clear();
    }

    private void fireSeverEvent(SubSystem server, ServerEventEnums eventID, Map eventContext) {
        try {
            ServerEvent<SubSystem> event = new ServerEvent<SubSystem>(server, eventID, this.getCurrServerBean().getId());
            event.setContextMap(eventContext);
            ClusterEventControl.getInstance().dispatchEvent((JDSEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        classPath.addComponent(JDSConfig.Config.libPath());
        if (JDSConfig.Config.libPath().exists() && JDSConfig.Config.libPath().isDirectory()) {
            JDSServer.loadLibs(JDSConfig.Config.libPath());
        }
        JDSServer.initPoolClassPah(JDSConfig.Config.rootServerHome());
        System.setProperty("java.class.path", classPath.toString());
        config = new SerializeConfig();
        JDSServer.config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
        clearSensorservice = Executors.newFixedThreadPool(50, new JDSThreadFactory("JDSServer.clearSensorservice"));
        lock = new ReentrantReadWriteLock(false);
        dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS zzz");
        clientServiceMap = new ConcurrentHashMap<String, ConcurrentMap<ConfigCode, JDSClientService>>();
    }
}

