/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server;

import com.ds.common.cache.Cache;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.engine.ConnectInfo;
import com.ds.engine.JDSSessionHandle;
import com.ds.server.JDSServer;
import java.util.ArrayList;
import java.util.Set;

public class ClearSessionCheckTask
implements Runnable {
    private static final Log logger = LogFactory.getLog("JDS", ClearSessionCheckTask.class);
    private long expireTime;
    private String systemCode;

    public ClearSessionCheckTask(long expireTime) {
        this.expireTime = expireTime;
    }

    public ClearSessionCheckTask(long expireTime, String systemCode) {
        this.expireTime = expireTime;
        this.systemCode = systemCode;
    }

    @Override
    public void run() {
        try {
            if (JDSServer.getInstance().started()) {
                ArrayList<JDSSessionHandle> invalidSessionList = new ArrayList<JDSSessionHandle>();
                long currentTime = System.currentTimeMillis();
                Cache<String, JDSSessionHandle> cache = JDSServer.getInstance().getSessionHandleCache();
                Set ites = JDSServer.getInstance().getSessionHandleCache().keySet();
                Integer size = ites.size();
                Thread.currentThread().setName("ClearSessionCheckTask size" + ites.size());
                for (String sessionId : ites) {
                    Object obj = cache.get(sessionId);
                    if (obj != null && obj instanceof JDSSessionHandle) {
                        ConnectInfo connectInfo = JDSServer.getInstance().getConnectInfo((JDSSessionHandle)obj);
                        if (connectInfo != null && connectInfo.getLoginName() != null && connectInfo.getLoginName().length() == 11) {
                            invalidSessionList.add((JDSSessionHandle)obj);
                        }
                        JDSServer.getInstance();
                        String code = (String)JDSServer.getSessionhandleSystemCodeCache().get(obj.toString());
                        if (code != null && !code.equals("gateway")) {
                            JDSServer.getInstance();
                            JDSServer.getSessionhandleSystemCodeCache().put(obj.toString(), "gateway");
                        }
                    }
                    Integer n = size;
                    Integer n2 = size = Integer.valueOf(size - 1);
                    Thread.currentThread().setName("ClearSessionCheckTask size" + n);
                }
                JDSServer.getInstance().invalidateSession(invalidSessionList);
            }
        }
        catch (Exception bpme) {
            logger.error("Get WorkflowServer instance failed.", bpme);
        }
    }
}

