/*
 * Decompiled with CFR 0.152.
 */
package com.ds.jds.core.esb.util;

import com.ds.common.cache.CacheObject;
import com.ds.esb.util.EsbFactory;
import com.ds.jds.core.esb.util.OgnlContextState;
import java.util.Map;
import ognl.MapPropertyAccessor;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDSMapPropertyAccessor
extends MapPropertyAccessor {
    private static final Log _log = LogFactory.getLog(JDSMapPropertyAccessor.class);
    private static final String[] INDEX_ACCESS_PROPS = new String[]{"size", "isEmpty", "keys", "values"};

    public Object getProperty(Map context, Object target, Object name) throws OgnlException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Entering getProperty (" + context + "," + target + "," + name + ")"));
        }
        OgnlContextState.updateCurrentPropertyPath(context, name);
        if (name instanceof String && this.contains(INDEX_ACCESS_PROPS, (String)name)) {
            return super.getProperty(context, target, name);
        }
        Object result = null;
        try {
            result = super.getProperty(context, target, name);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (name instanceof String && ((String)name).startsWith("$") && result == null) {
            result = EsbFactory.par((String)name);
        }
        if (result instanceof String && ((String)result).startsWith("$")) {
            result = EsbFactory.par((String)name);
        }
        if (result instanceof CacheObject) {
            result = ((CacheObject)result).object;
        }
        return result;
    }

    private boolean contains(String[] array, String name) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(name)) continue;
            return true;
        }
        return false;
    }
}

