/*
 * Decompiled with CFR 0.152.
 */
package com.ds.jds.core.esb.util;

import com.ds.jds.core.esb.util.ActionContext;
import com.ds.jds.core.esb.util.JDSConverter;
import com.ds.jds.core.esb.util.ObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDSList
extends ArrayList {
    private static final Log LOG = LogFactory.getLog(JDSList.class);
    private Class clazz;

    public JDSList(Class clazz) {
        this.clazz = clazz;
    }

    public JDSList(Class clazz, Collection c) {
        super(c.size());
        this.clazz = clazz;
        this.addAll(c);
    }

    public JDSList(Class clazz, int initialCapacity) {
        super(initialCapacity);
        this.clazz = clazz;
    }

    @Override
    public void add(int index, Object element) {
        if (index >= this.size()) {
            this.get(index);
        }
        element = this.convert(element);
        super.add(index, element);
    }

    @Override
    public boolean add(Object element) {
        element = this.convert(element);
        return super.add(element);
    }

    @Override
    public boolean addAll(Collection c) {
        if (c == null) {
            throw new NullPointerException("Collection to add is null");
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new NullPointerException("Collection to add is null");
        }
        boolean trim = false;
        if (index >= this.size()) {
            trim = true;
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(index, it.next());
            ++index;
        }
        if (trim) {
            this.remove(this.size() - 1);
        }
        return true;
    }

    @Override
    public synchronized Object get(int index) {
        while (index >= this.size()) {
            try {
                this.add(ObjectFactory.getObjectFactory().buildBean(this.clazz, null));
            }
            catch (Exception e) {
                try {
                    throw new Exception(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return super.get(index);
    }

    @Override
    public Object set(int index, Object element) {
        if (index >= this.size()) {
            this.get(index);
        }
        element = this.convert(element);
        return super.set(index, element);
    }

    private Object convert(Object element) {
        if (element != null && !this.clazz.isAssignableFrom(element.getClass())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Converting from " + element.getClass().getName() + " to " + this.clazz.getName()));
            }
            Map context = ActionContext.getContext().getContextMap();
            element = JDSConverter.getInstance().convertValue(context, null, null, null, element, this.clazz);
        }
        return element;
    }

    @Override
    public boolean contains(Object element) {
        element = this.convert(element);
        return super.contains(element);
    }
}

