/*
 * Decompiled with CFR 0.152.
 */
package com.ds.jds.core.esb.util;

import com.ds.context.JDSActionContext;
import com.ds.esb.config.manager.JDSExpressionParserManager;
import com.ds.jds.core.esb.util.ValueStack;
import com.ds.jds.core.esb.util.ValueStackFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionContext
extends ParserContext
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ActionContext.class);
    static ThreadLocal actionContext = new ActionContextThreadLocal();
    public static final String ACTION_NAME = "com.ds.jds.core.esb.ActionContext.name";
    public static final String VALUE_STACK = "com.ds.jds.core.esb.util.ValueStack.ValueStack";
    public static final String SESSION = "com.ds.jds.core.esb.ActionContext.session";
    public static final String REQUEST = "com.ds.jds.core.esb.ActionContext.request";
    public static final String APPLICATION = "com.ds.jds.core.esb.ActionContext.application";
    public static final String PARAMETERS = "com.ds.jds.core.esb.ActionContext.parameters";
    public static final String LOCALE = "com.ds.jds.core.esb.ActionContext.locale";
    public static final String TYPE_CONVERTER = "com.ds.jds.core.esb.ActionContext.typeConverter";
    public static final String ACTION_INVOCATION = "com.ds.jds.core.esb.ActionContext.actionInvocation";
    public static final String CONVERSION_ERRORS = "com.ds.jds.core.esb.ActionContext.conversionErrors";
    Map context;

    public ActionContext(Map context) {
        this.context = context;
    }

    public void setApplication(Map application) {
        this.put(APPLICATION, application);
    }

    public Map getApplication() {
        return (Map)this.get(APPLICATION);
    }

    public static void setContext(ActionContext context) {
        actionContext.set(context);
    }

    public static ActionContext getContext() {
        ActionContext context = (ActionContext)actionContext.get();
        ParserContext parserContext = new ParserContext();
        parserContext.setImports(JDSExpressionParserManager.getExpressionTypeMap());
        ValueStack vs = ValueStackFactory.getFactory().createValueStack();
        if (context == null) {
            logger.warn("contextInfoIsNull");
            context = new ActionContext(vs.getContext());
            ActionContext.setContext(context);
        }
        context.getContextMap().putAll(JDSActionContext.getActionContext().getContext());
        context.setValueStack(vs);
        return context;
    }

    public void setContextMap(Map contextMap) {
        ActionContext.getContext().context = contextMap;
    }

    public Map getContextMap() {
        return this.context;
    }

    public void setConversionErrors(Map conversionErrors) {
        this.put(CONVERSION_ERRORS, conversionErrors);
    }

    public Map getConversionErrors() {
        HashMap errors = (HashMap)this.get(CONVERSION_ERRORS);
        if (errors == null) {
            errors = new HashMap();
            this.setConversionErrors(errors);
        }
        return errors;
    }

    public void setLocale(Locale locale) {
        this.put(LOCALE, locale);
    }

    public Locale getLocale() {
        Locale locale = (Locale)this.get(LOCALE);
        if (locale == null) {
            locale = Locale.getDefault();
            this.setLocale(locale);
        }
        return locale;
    }

    public void setName(String name) {
        this.put(ACTION_NAME, name);
    }

    public String getName() {
        return (String)this.get(ACTION_NAME);
    }

    public void setParameters(Map parameters) {
        this.put(PARAMETERS, parameters);
    }

    public Map getParameters() {
        return (Map)this.get(PARAMETERS);
    }

    public void setSession(Map session) {
        this.put(SESSION, session);
    }

    public Map getSession() {
        return (Map)this.get(SESSION);
    }

    public void setValueStack(ValueStack stack) {
        this.put(VALUE_STACK, stack);
    }

    public ValueStack getValueStack() {
        return (ValueStack)this.get(VALUE_STACK);
    }

    public Object get(Object key) {
        return this.context.get(key);
    }

    public void put(Object key, Object value) {
        this.context.put(key, value);
    }

    private static class ActionContextThreadLocal
    extends ThreadLocal {
        private ActionContextThreadLocal() {
        }

        protected Object initialValue() {
            ValueStack vs = ValueStackFactory.getFactory().createValueStack();
            ActionContext context = new ActionContext(vs.getContext());
            context.setImports(JDSExpressionParserManager.getExpressionTypeMap());
            return context;
        }
    }
}

