/*
 * Decompiled with CFR 0.152.
 */
package com.ds.jds.core.esb.mvel;

import com.ds.common.cache.CacheObject;
import com.ds.esb.util.EsbFactory;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.integration.VariableResolver;

public class JDSMapVariableResolver
implements VariableResolver {
    private String name;
    private Class<?> knownType;
    private Map variableMap;
    private boolean cache = false;

    public JDSMapVariableResolver(Map variableMap, String name) {
        this.variableMap = variableMap;
        this.name = name;
    }

    public JDSMapVariableResolver(Map variableMap, String name, Class knownType) {
        this.name = name;
        this.knownType = knownType;
        this.variableMap = variableMap;
    }

    public JDSMapVariableResolver(Map variableMap, String name, boolean cache) {
        this.variableMap = variableMap;
        this.name = name;
        this.cache = cache;
    }

    public JDSMapVariableResolver(Map variableMap, String name, Class knownType, boolean cache) {
        this.name = name;
        this.knownType = knownType;
        this.variableMap = variableMap;
        this.cache = cache;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStaticType(Class knownType) {
        this.knownType = knownType;
    }

    public void setVariableMap(Map variableMap) {
        this.variableMap = variableMap;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.knownType;
    }

    public void setValue(Object value) {
        if (this.knownType != null && value != null && value.getClass() != this.knownType) {
            if (!DataConversion.canConvert(this.knownType, value.getClass())) {
                throw new CompileException("cannot assign " + value.getClass().getName() + " to type: " + this.knownType.getName(), null, 0);
            }
            try {
                value = DataConversion.convert((Object)value, this.knownType);
            }
            catch (Exception e) {
                throw new CompileException("cannot convert value of " + value.getClass().getName() + " to: " + this.knownType.getName(), null, 0, (Throwable)e);
            }
        }
        this.variableMap.put(this.name, value);
    }

    public Object getValue() {
        Object result = this.variableMap.get(this.name);
        if (this.name instanceof String && this.name.startsWith("$") && result == null) {
            result = EsbFactory.par(this.name);
        }
        if (result instanceof String && ((String)result).startsWith("$")) {
            result = EsbFactory.par(this.name);
        }
        if (result instanceof CacheObject) {
            result = ((CacheObject)result).object;
        }
        return result;
    }

    public int getFlags() {
        return 0;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }
}

