/*
 * Decompiled with CFR 0.152.
 */
package com.ds.hsql;

import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheManager;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSConfig;
import com.ds.hsql.HsqlDbCacheFactory;
import com.ds.hsql.HsqlDbServer;
import com.ds.org.conf.OrgConstants;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class HsqlDbCacheManager {
    private static final Log log = LogFactory.getLog(OrgConstants.CONFIG_KEY.getType(), HsqlDbCacheManager.class);
    public static String TABLE_NAME = "CACHE";
    public static final String CREATE_CACHETABLE_SQL = "CREATE TABLE " + TABLE_NAME + " (CACHE_NAME VARCHAR(50), CACHE_KEY VARCHAR(100), CACHE_VALUE OBJECT, UPDATE_TIME BIGINT)";
    public static final String CREATE_INDEX_SQL = "CREATE INDEX IDX_" + TABLE_NAME + "_NAME_KEY ON " + TABLE_NAME + " (CACHE_NAME, CACHE_KEY)";
    public static final String CREATE_INDEX_SQL2 = "CREATE INDEX IDX_" + TABLE_NAME + "_NAME ON " + TABLE_NAME + " (CACHE_NAME)";
    public static final String THREAD_LOCK = "Thread Lock";
    private static final String LOAD_CACHE_SQL = "SELECT CACHE_NAME, CACHE_KEY, CACHE_VALUE FROM " + TABLE_NAME;
    private static final String INSERT_CACHE_SQL = "INSERT INTO " + TABLE_NAME + " (CACHE_NAME, CACHE_KEY, CACHE_VALUE) VALUES(?, ?, ?)";
    private static final String DELETE_CACHE_SQL = "DELETE FROM " + TABLE_NAME;
    private boolean cacheEnabled = true;
    private boolean dumpCache = false;
    private static Map cacheMap = new HashMap();
    private static HsqlDbServer db;
    private static HsqlDbCacheManager manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HsqlDbCacheManager getInstance() {
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (manager == null) {
                manager = new HsqlDbCacheManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HsqlDbCacheManager() {
        String dbName;
        String path;
        String cacheDbPassword;
        String cacheDbUser;
        String dumpCacheStr;
        String cacheEnabledStr = JDSConfig.getValue("hsql.cacheEnabled");
        if (cacheEnabledStr != null) {
            this.cacheEnabled = Boolean.valueOf(cacheEnabledStr);
        }
        if ((dumpCacheStr = JDSConfig.getValue("hsql.dumpCache")) != null) {
            this.dumpCache = Boolean.valueOf(dumpCacheStr);
        }
        if ((cacheDbUser = JDSConfig.getValue("hsql.cacheDbUser")) == null) {
            cacheDbUser = "sa";
        }
        if ((cacheDbPassword = JDSConfig.getValue("hsql.cacheDbPassword")) == null) {
            cacheDbPassword = "";
        }
        if ((path = JDSConfig.getValue("hsql.dataPath")) == null || path.equals("")) {
            path = JDSConfig.Config.dataPath() + File.separator + "ClientCache";
        }
        if ((dbName = JDSConfig.getValue("hsql.dbName")) == null) {
            dbName = "mydb";
        }
        String port = this.getLocalPort();
        String cacheDbURL = JDSConfig.getValue("hsql.url");
        if (cacheDbURL == null) {
            cacheDbURL = "jdbc:hsqldb:file:" + path + "/" + dbName;
        }
        ResultSet rsTableName = null;
        Statement st = null;
        Connection conn = null;
        try {
            db = new HsqlDbServer(cacheDbURL, cacheDbUser, cacheDbPassword, path, dbName, Integer.valueOf(port), log.isTraceEnabled());
            db.startup();
            conn = db.newConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            rsTableName = metaData.getTables(null, null, TABLE_NAME, null);
            if (!rsTableName.next()) {
                st = conn.createStatement();
                st.execute(CREATE_CACHETABLE_SQL);
                st.execute(CREATE_INDEX_SQL);
                st.execute(CREATE_INDEX_SQL2);
            }
        }
        catch (Exception e) {
            log.error("", e);
        }
        finally {
            try {
                if (rsTableName != null) {
                    rsTableName.close();
                }
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                log.error("", e1);
            }
        }
        cacheMap = new HashMap();
    }

    private String getLocalPort() {
        ServerSocket s = null;
        String port = "8083";
        try {
            s = new ServerSocket(0);
            port = s.getLocalPort() + "";
            s.close();
        }
        catch (MalformedURLException e3) {
            e3.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCache(String cacheKey) {
        CacheManager cacheManager = CacheManagerFactory.getInstance().getCacheManager(cacheKey);
        if (cacheManager.isCacheEnabled()) {
            Connection conn = null;
            ResultSet rsTableName = null;
            Statement stmnt = null;
            ResultSet rs = null;
            HashMap<String, Integer> cacheLoadMap = new HashMap<String, Integer>();
            try {
                conn = db.newConnection();
                DatabaseMetaData metaData = conn.getMetaData();
                rsTableName = metaData.getTables(null, null, "CACHE", null);
                if (rsTableName.next()) {
                    stmnt = conn.createStatement();
                    rs = stmnt.executeQuery(LOAD_CACHE_SQL);
                    int k = 0;
                    while (rs.next()) {
                        k = k++;
                        String cacheName = rs.getString(1);
                        Cache cache = null;
                        cache = cacheName.indexOf(".") > -1 ? cacheManager.getCache(StringUtility.split(cacheName, ".")[1]) : HsqlDbCacheManager.getCache(cacheName);
                        if (cache == null) continue;
                        cache.put((String)rs.getObject(2), rs.getObject(3));
                        Integer cacheCount = (Integer)cacheLoadMap.get(cacheName);
                        cacheCount = cacheCount == null ? new Integer(1) : new Integer(cacheCount + 1);
                        cacheLoadMap.put(cacheName, cacheCount);
                    }
                    rs.close();
                    stmnt.close();
                } else {
                    stmnt = conn.createStatement();
                    stmnt.execute(CREATE_CACHETABLE_SQL);
                }
                rsTableName.close();
                conn.close();
            }
            catch (Exception e) {
                log.error("", e);
            }
            finally {
                if (rsTableName != null) {
                    try {
                        rsTableName.close();
                    }
                    catch (SQLException e) {}
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (stmnt != null) {
                    try {
                        stmnt.close();
                    }
                    catch (SQLException e) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {}
                }
            }
            for (String cacheName : cacheLoadMap.keySet()) {
                int cacheCount = (Integer)cacheLoadMap.get(cacheName);
                log.info("Load dumped cache data - " + cacheName + "(" + cacheCount + ")");
            }
        } else {
            log.info("- Cache enabled            [false]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCache() {
        if (db != null) {
            Connection conn = null;
            Statement deleteCacheStm = null;
            Statement insertCacheStm = null;
            HashMap cacheDumpMap = new HashMap();
            try {
                conn = db.newConnection();
                conn.setAutoCommit(false);
                deleteCacheStm = conn.prepareStatement(DELETE_CACHE_SQL);
                deleteCacheStm.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                log.error("", e);
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (deleteCacheStm != null) {
                    try {
                        deleteCacheStm.close();
                    }
                    catch (Exception exception) {}
                }
                if (insertCacheStm != null) {
                    try {
                        insertCacheStm.close();
                    }
                    catch (Exception exception) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCache(String configKey) {
        if (db != null) {
            Connection conn = null;
            Statement deleteCacheStm = null;
            Statement insertCacheStm = null;
            HashMap<String, Integer> cacheDumpMap = new HashMap<String, Integer>();
            try {
                conn = db.newConnection();
                conn.setAutoCommit(false);
                deleteCacheStm = conn.prepareStatement(DELETE_CACHE_SQL);
                deleteCacheStm.executeUpdate();
                insertCacheStm = conn.prepareStatement(INSERT_CACHE_SQL);
                CacheManager cacheManager = CacheManagerFactory.getInstance().getCacheManager(configKey);
                if (cacheManager.isCacheEnabled()) {
                    Map cacheMap = cacheManager.getAllCache();
                    for (String cacheName : cacheMap.keySet()) {
                        Cache cache = (Cache)cacheMap.get(cacheName);
                        for (Object cacheKey : cache.keySet()) {
                            Object cacheValue = cache.get(cacheKey);
                            if (cacheKey == null || cacheValue == null) continue;
                            try {
                                insertCacheStm.setString(1, cacheName);
                                insertCacheStm.setObject(2, cacheKey);
                                insertCacheStm.setObject(3, cacheValue);
                                insertCacheStm.executeUpdate();
                                Integer cacheCount = (Integer)cacheDumpMap.get(cacheName);
                                cacheCount = cacheCount == null ? new Integer(1) : new Integer(cacheCount + 1);
                                cacheDumpMap.put(cacheName, cacheCount);
                            }
                            catch (Exception e) {
                                log.error("", e);
                            }
                        }
                    }
                }
                conn.commit();
            }
            catch (Exception e) {
                log.error("", e);
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception cacheMap) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (deleteCacheStm != null) {
                    try {
                        deleteCacheStm.close();
                    }
                    catch (Exception e) {}
                }
                if (insertCacheStm != null) {
                    try {
                        insertCacheStm.close();
                    }
                    catch (Exception e) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {}
                }
            }
            for (String cacheName : cacheDumpMap.keySet()) {
                int cacheCount = (Integer)cacheDumpMap.get(cacheName);
                log.info("Dumped cache data - " + cacheName + "(" + cacheCount + ")");
            }
        }
    }

    public static Cache getCache(String cacheKey) {
        return HsqlDbCacheManager.getInstance().getCacheNS(cacheKey);
    }

    public Cache getCacheNS(String cacheKey) {
        Cache cache = (Cache)cacheMap.get(cacheKey);
        if (cache == null) {
            int cacheSize = 0x100000;
            String cacheSizeString = JDSConfig.getValue("cache." + cacheKey + ".size");
            if (cacheSizeString != null) {
                try {
                    cacheSize = Integer.parseInt(cacheSizeString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long cacheLifeTime = 28800000L;
            String cacheLifeTimeString = JDSConfig.getValue("cache." + cacheKey + ".lifeTime");
            if (cacheLifeTimeString != null) {
                try {
                    cacheLifeTime = Long.parseLong(cacheLifeTimeString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            cache = HsqlDbCacheFactory.createCache(cacheKey, cacheSize, cacheLifeTime, db);
            cacheMap.put(cacheKey, cache);
        }
        return cache;
    }

    public Map getAllCacheNS() {
        return cacheMap;
    }

    public static Map getAllCache() {
        return HsqlDbCacheManager.getInstance().getAllCacheNS();
    }

    public boolean isCacheEnabledNS() {
        return this.cacheEnabled;
    }

    public static boolean isCacheEnabled() {
        return HsqlDbCacheManager.getInstance().isCacheEnabledNS();
    }
}

