/*
 * Decompiled with CFR 0.152.
 */
package com.ds.hsql;

import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheSizes;
import com.ds.common.cache.Cacheable;
import com.ds.hsql.HsqlDbCacheManager;
import com.ds.hsql.HsqlDbServer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class HsqlDbCache
implements Cache {
    protected Connection conn;
    public static final String TABLE_NAME = HsqlDbCacheManager.TABLE_NAME;
    public static final String DELETE_CACHE_SQL = "DELETE FROM " + TABLE_NAME + " WHERE CACHE_NAME=? AND CACHE_KEY=? ";
    public static final String DELETE_CACHE_BYTIME_SQL = "DELETE FROM " + TABLE_NAME + " WHERE CACHE_NAME=? AND UPDATE_TIME<? ";
    public static final String DELETE_CACHE_BYNAME_SQL = "DELETE FROM " + TABLE_NAME + " WHERE CACHE_NAME=? ";
    public static final String INSERT_CACHE_SQL = "INSERT INTO " + TABLE_NAME + " (CACHE_NAME, CACHE_KEY, CACHE_VALUE, UPDATE_TIME) VALUES(?, ?, ?, ?)";
    public static final String LOAD_ALL_CACHE_SQL = "SELECT CACHE_NAME, CACHE_KEY, CACHE_VALUE, UPDATE_TIME FROM " + TABLE_NAME;
    public static final String LOAD_CACHE_SQL = "SELECT CACHE_NAME, CACHE_KEY, CACHE_VALUE, UPDATE_TIME FROM " + TABLE_NAME + " WHERE CACHE_NAME=? AND CACHE_KEY=?";
    public static final String LOAD_CACHE_BYNAME_SQL = "SELECT CACHE_NAME, CACHE_KEY, CACHE_VALUE, UPDATE_TIME FROM " + TABLE_NAME + " WHERE CACHE_NAME=?";
    public static final String LOAD_CACHE_COUNT_SQL = "SELECT COUNT(*) FROM " + TABLE_NAME + " WHERE CACHE_NAME=?";
    public static final String LOAD_CACHE_BYNAME_ORDERED_SQL = "SELECT CACHE_NAME, CACHE_KEY, CACHE_VALUE, UPDATE_TIME FROM " + TABLE_NAME + " WHERE CACHE_NAME=? ORDER BY UPDATE_TIME";
    protected int maxCacheSize;
    protected int cacheSize = 0;
    protected long maxLifetime;
    protected long cacheHits;
    protected long cacheMisses = 0L;
    protected String name;
    private boolean isFull;
    protected boolean isStopPutWhenFull;

    public HsqlDbCache(String name, int maxSize, long maxLifetime, HsqlDbServer db) {
        this.name = name;
        this.maxCacheSize = maxSize;
        this.maxLifetime = maxLifetime;
        this.conn = db.newConnection();
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (key == null) {
            return null;
        }
        if (this.isStopPutWhenFull && this.isFull) {
            return value;
        }
        int objectSize = this.calculateSize(value);
        if (this.maxCacheSize > 0 && (double)objectSize > (double)this.maxCacheSize * 0.9) {
            return value;
        }
        this.cacheSize += objectSize;
        if (this.isStopPutWhenFull && this.maxCacheSize > 0 && this.cacheSize > this.maxCacheSize) {
            this.isFull = true;
            return value;
        }
        this.remove(key);
        this.addToDb(key, value);
        if (!this.isStopPutWhenFull) {
            this.cullCache();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDb(Object key, Object value) {
        PreparedStatement pst = null;
        try {
            pst = this.conn.prepareStatement(INSERT_CACHE_SQL);
            pst.setString(1, this.name);
            pst.setString(2, key.toString());
            pst.setObject(3, value);
            pst.setLong(4, System.currentTimeMillis());
            pst.executeUpdate();
        }
        catch (Exception ex) {
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] loadAllFromDb() {
        PreparedStatement pst = null;
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            pst = this.conn.prepareStatement(LOAD_CACHE_BYNAME_SQL);
            pst.setString(1, this.name);
            ResultSet rs = pst.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    result.add(rs.getObject(3));
                }
                rs.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception exception) {}
        }
        return result.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadFromDb(Object key) {
        PreparedStatement pst = null;
        Object o = null;
        try {
            pst = this.conn.prepareStatement(LOAD_CACHE_SQL);
            pst.setString(1, this.name);
            pst.setString(2, key.toString());
            ResultSet rs = pst.executeQuery();
            if (rs != null && rs.next()) {
                o = rs.getObject(3);
                rs.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception exception) {}
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadAgestFromDb() {
        PreparedStatement pst = null;
        Object o = null;
        try {
            pst = this.conn.prepareStatement(LOAD_CACHE_BYNAME_ORDERED_SQL);
            pst.setString(1, this.name);
            ResultSet rs = pst.executeQuery();
            if (rs != null && rs.next()) {
                o = rs.getObject(3);
                rs.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception exception) {}
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDb(Object key) {
        PreparedStatement pst = null;
        try {
            pst = this.conn.prepareStatement(DELETE_CACHE_SQL);
            pst.setString(1, this.name);
            pst.setString(2, key.toString());
            pst.executeUpdate();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public synchronized Object get(Object key) {
        if (key == null) {
            return null;
        }
        this.deleteExpiredEntries();
        return this.loadFromDb(key);
    }

    @Override
    public synchronized Object remove(Object key) {
        if (key == null) {
            return null;
        }
        Object object = this.loadFromDb(key);
        if (object == null) {
            return null;
        }
        this.removeFromDb(key);
        this.isFull = false;
        this.cacheSize -= this.calculateSize(object);
        return object;
    }

    @Override
    public synchronized void clear() {
        PreparedStatement pst = null;
        try {
            pst = this.conn.prepareStatement(DELETE_CACHE_BYNAME_SQL);
            pst.setString(1, this.name);
            pst.executeUpdate();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception exception) {}
        }
        this.cacheSize = 0;
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.isFull = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.deleteExpiredEntries();
        PreparedStatement pst = null;
        int size = 0;
        try {
            pst = this.conn.prepareStatement(LOAD_CACHE_COUNT_SQL);
            pst.setString(1, this.name);
            ResultSet rs = pst.executeQuery();
            if (rs != null && rs.next()) {
                size = rs.getInt(1);
                rs.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception exception) {}
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        this.deleteExpiredEntries();
        return false;
    }

    @Override
    public Collection values() {
        this.deleteExpiredEntries();
        Object[] objects = this.loadAllFromDb();
        Object[] values = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            values[i] = objects[i];
        }
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    @Override
    public boolean containsKey(Object key) {
        this.deleteExpiredEntries();
        return this.loadFromDb(key) != null;
    }

    @Override
    public void putAll(Map map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            this.put(key, value);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.deleteExpiredEntries();
        int objectSize = this.calculateSize(value);
        return false;
    }

    @Override
    public Set entrySet() {
        this.deleteExpiredEntries();
        return null;
    }

    @Override
    public Set keySet() {
        this.deleteExpiredEntries();
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getCacheHits() {
        return this.cacheHits;
    }

    @Override
    public long getCacheMisses() {
        return this.cacheMisses;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.cullCache();
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    protected int calculateSize(Object object) {
        if (object == null) {
            return 4;
        }
        if (object instanceof Cacheable) {
            return ((Cacheable)object).getCachedSize();
        }
        if (object instanceof String) {
            return CacheSizes.sizeOfString((String)object);
        }
        if (object instanceof DataInputStream) {
            int size = 1;
            try {
                size = ((DataInputStream)object).available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return size;
        }
        if (object instanceof Long) {
            return CacheSizes.sizeOfLong();
        }
        if (object instanceof Integer) {
            return CacheSizes.sizeOfObject() + CacheSizes.sizeOfInt();
        }
        if (object instanceof Boolean) {
            return CacheSizes.sizeOfObject() + CacheSizes.sizeOfBoolean();
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            return CacheSizes.sizeOfObject() + array.length * CacheSizes.sizeOfLong();
        }
        int size = 1;
        return size;
    }

    protected void deleteExpiredEntries() {
        if (this.maxLifetime <= 0L) {
            return;
        }
        long expireTime = System.currentTimeMillis() - this.maxLifetime;
        PreparedStatement pst = null;
        try {
            pst = this.conn.prepareStatement(DELETE_CACHE_BYTIME_SQL);
            pst.setString(1, this.name);
            pst.setLong(2, expireTime);
            pst.executeUpdate();
        }
        catch (Exception e) {
            try {
                pst.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void cullCache() {
        if (this.maxCacheSize < 0) {
            return;
        }
        if ((double)this.cacheSize >= (double)this.maxCacheSize * 0.97) {
            this.deleteExpiredEntries();
            int desiredSize = (int)((double)this.maxCacheSize * 0.95);
            while (this.cacheSize > desiredSize) {
                this.remove(this.loadAgestFromDb());
            }
        }
    }

    @Override
    public void setStopPutWhenFull(boolean flag) {
        this.isStopPutWhenFull = flag;
    }

    private static class NullOutputStream
    extends OutputStream {
        int size = 0;

        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.size += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.size += len;
        }

        public int size() {
            return this.size;
        }
    }
}

