/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esb.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ds.client.JDSSessionFactory;
import com.ds.common.JDSException;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.expression.ParseException;
import com.ds.common.expression.function.Function;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.esb.config.ContextType;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.EsbObj;
import com.ds.esb.config.EsbRequest;
import com.ds.esb.config.StaticBean;
import com.ds.esb.config.invocation.DebugInterceptor;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.JDSExpressionParserManager;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esb.expression.CTXMacro;
import com.ds.esb.expression.RemoteAdminFunction;
import com.ds.esb.expression.RemoteClientFunction;
import com.ds.esb.expression.RemoteFunction;
import com.ds.jds.core.esb.util.ActionContext;
import com.ds.server.JDSClientService;
import com.ds.server.eumus.ConfigCode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InterfaceMaker;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.Mixin;
import org.mvel2.MVEL;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.MethodStub;
import org.mvel2.util.ParseTools;
import org.objectweb.asm.Type;
import org.springframework.beans.factory.annotation.Autowired;

public class EsbFactory {
    private static final Log logger = LogFactory.getLog("esb", EsbFactory.class);
    private static final Map signatureMap = new HashMap();
    private static final Map<String, ExpressionCompiler> compilerMap = new HashMap<String, ExpressionCompiler>();
    private static Class[] JSONClass = new Class[]{JSONObject.class, JSONArray.class};
    private static Class contextClass;
    private static Object esbContext;
    private static final String EsbKey = "$";
    private static final String ESBMVELSOURCE = "ESBMVELSOURCE";
    private static boolean init;

    public static synchronized void initBus() {
        try {
            if (!init) {
                EsbFactory.loadStaticAllData(true);
                EsbFactory.getEsbContext();
                init = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void reload() {
        EsbFactory.creatStaticBean(true);
    }

    public static Map<String, Object> getContextRoot(boolean load) {
        HashMap<String, Object> contextRoot = new HashMap<String, Object>();
        EsbBeanFactory factory = EsbBeanFactory.getInstance();
        List<? extends ServiceBean> expressionList = factory.loadAllServiceBean();
        for (int i = 0; i < expressionList.size(); ++i) {
            if (!(expressionList.get(i) instanceof ExpressionTempBean)) continue;
            ExpressionTempBean bean = (ExpressionTempBean)expressionList.get(i);
            if (!load && (bean.getDataType() == null || !bean.getDataType().equals(ContextType.Action))) continue;
            String id = bean.getId();
            contextRoot.put(EsbKey + id, null);
            contextRoot.put(id, null);
        }
        return contextRoot;
    }

    static Object eval(String expression) {
        return MVEL.eval((String)expression, (Object)EsbFactory.creatStaticBean(false));
    }

    public static Object par(String expression) {
        return EsbFactory.par(expression, Object.class);
    }

    public static Method getESBMethod(Class clazz) {
        ExpressionTempBean bean = EsbBeanFactory.getInstance().getDefaultServiceBean(clazz);
        if (bean != null) {
            return EsbFactory.getESBMethod(bean.getId());
        }
        return null;
    }

    public static Method getESBMethod(String expression) {
        if (expression != null) {
            Method[] methods;
            if (!expression.startsWith(EsbKey)) {
                expression = EsbKey + expression;
            }
            for (Method method : methods = EsbFactory.getEsbContext().getDeclaredMethods()) {
                if (!method.getName().equals("get" + expression)) continue;
                return method;
            }
        }
        return null;
    }

    public static <T> T par(Class<T> clazz) {
        T object = null;
        ExpressionTempBean bean = EsbBeanFactory.getInstance().getDefaultServiceBean(clazz);
        if (bean != null) {
            String expression = EsbBeanFactory.getInstance().getDefaultServiceBean(clazz).getId();
            object = EsbFactory.par(EsbKey + expression, clazz);
        }
        return object;
    }

    public static <T> T par(String expression, Class<T> clazz) {
        ExpressionTempBean bean;
        T obj = null;
        if (!init) {
            EsbFactory.initBus();
        }
        obj = expression != null && expression.startsWith(EsbKey) ? ((bean = (ExpressionTempBean)EsbBeanFactory.getInstance().getEsbBeanById(expression)) != null && bean.getDataType() != null ? (T)EsbFactory.getContextRootById(expression, clazz) : (T)EsbFactory.par(expression, ActionContext.getContext().getContextMap(), clazz)) : (T)EsbFactory.par(expression, ActionContext.getContext().getContextMap(), clazz);
        return obj;
    }

    public static <T> T par(String expression, Map context, Class<T> clazz) {
        if (!init) {
            EsbFactory.initBus();
        }
        T o = EsbFactory.par(expression, context, EsbFactory.getContext(), clazz);
        return o;
    }

    private static Object getContextRootById(String objId) {
        return EsbFactory.getContextRootById(objId, Object.class);
    }

    static JDSClientService getCurrJDSClient() {
        JDSContext context = JDSActionContext.getActionContext();
        JDSSessionFactory factory = new JDSSessionFactory(context);
        String systemCode = JDSActionContext.getActionContext().getSystemCode();
        ConfigCode configCode = JDSActionContext.getActionContext().getConfigCode();
        String sessionId = JDSActionContext.getActionContext().getSessionId();
        JDSClientService client = null;
        try {
            client = factory.getClientService(configCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (client == null && sessionId != null) {
            try {
                client = factory.getJDSClientBySessionId(sessionId, configCode);
            }
            catch (JDSException jDSException) {
                // empty catch block
            }
        }
        return client;
    }

    private static Object runExpression(ExpressionTempBean bean) {
        Class clazz = (Class)JDSExpressionParserManager.getExpressionTypeMap().get(bean.getId());
        Function function = (Function)JDSExpressionParserManager.getName2functionMap().get(bean.getReturntype());
        Object returnObject = null;
        String expression = bean.getExpressionArr();
        List params = null;
        if (expression != null) {
            params = ParseTools.parseMethodOrConstructor((char[])expression.toCharArray());
        }
        if (function != null && clazz != null) {
            try {
                Stack<Object> stack = new Stack<Object>();
                for (int k = 0; k < params.size(); ++k) {
                    String param = new String((char[])params.get(k));
                    stack.push(EsbFactory.par(param));
                }
                function.run(stack);
                returnObject = stack.pop();
            }
            catch (Throwable e) {
                logger.error("ParseExpressionException:", e);
                e.printStackTrace();
            }
        }
        return returnObject;
    }

    private static <T> T getContextRootById(String objId, Class<T> clazz) {
        Object o;
        block29: {
            block28: {
                ExpressionTempBean bean = (ExpressionTempBean)EsbBeanFactory.getInstance().getEsbBeanById(objId);
                o = null;
                if (bean == null || bean.getDataType() == null) break block28;
                block3 : switch (bean.getDataType()) {
                    case Action: {
                        o = EsbFactory.runExpression(bean);
                        if (o == null) {
                            o = EsbFactory.par(bean.getExpressionArr(), clazz);
                            break;
                        }
                        break block29;
                    }
                    case Context: {
                        if (ActionContext.getContext().get(bean.getId()) == null) {
                            o = EsbFactory.runExpression(bean);
                            if (o == null) {
                                o = EsbFactory.par(bean.getExpressionArr(), clazz);
                            }
                            ActionContext.getContext().put(bean.getId(), o);
                        }
                        o = ActionContext.getContext().get(bean.getId());
                        break;
                    }
                    case Static: {
                        Map root = (Map)EsbFactory.getDefauleRoot();
                        if (!root.containsKey(EsbKey + bean.getId()) || root.get(EsbKey + bean.getId()) == null) {
                            o = EsbFactory.runExpression(bean);
                            if (o == null) {
                                o = EsbFactory.par(bean.getExpressionArr(), clazz);
                            }
                            if (o != null) {
                                root.put(EsbKey + bean.getId(), o);
                            }
                        }
                        o = root.get(EsbKey + bean.getId());
                        break;
                    }
                    case Session: {
                        if (ActionContext.getContext().getSession().get(bean.getId()) == null) {
                            o = EsbFactory.runExpression(bean);
                            if (o == null) {
                                o = EsbFactory.par(bean.getExpressionArr(), clazz);
                            }
                            ActionContext.getContext().getSession().put(bean.getId(), o);
                        }
                        o = ActionContext.getContext().getSession().get(bean.getId());
                        break;
                    }
                    case Server: {
                        if (bean.getServerUrl() != null && !bean.getServerUrl().equals("")) {
                            try {
                                switch (bean.getTokenType()) {
                                    case user: {
                                        RemoteClientFunction function = new RemoteClientFunction(EsbFactory.getCurrJDSClient(), bean.getClazz(), bean.getServerUrl());
                                        o = function.perform();
                                        break block3;
                                    }
                                    case admin: {
                                        RemoteAdminFunction adminFunction = new RemoteAdminFunction(bean.getClazz(), bean.getServerUrl());
                                        o = adminFunction.perform();
                                        break block3;
                                    }
                                    case guest: {
                                        RemoteFunction gustfunction = new RemoteFunction(bean.getClazz(), bean.getServerUrl());
                                        o = gustfunction.perform();
                                        break block3;
                                    }
                                }
                                RemoteFunction defaultFunction = new RemoteFunction(bean.getClazz(), bean.getServerUrl());
                                o = defaultFunction.perform();
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        o = EsbFactory.runExpression(bean);
                        if (o == null) {
                            o = EsbFactory.par(bean.getExpressionArr(), clazz);
                            break;
                        }
                        break block29;
                    }
                    default: {
                        try {
                            throw new JDSException("service key :" + objId + " not found! place check esbConfig.", 9999);
                        }
                        catch (JDSException e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                }
                break block29;
            }
            try {
                throw new JDSException("service key :" + objId + " not found! place check esbConfig.", 9999);
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
        }
        return (T)o;
    }

    public static Class guessType(String expression, Map context, Object obj) {
        if (obj == null) {
            obj = EsbFactory.creatStaticBean(true);
        } else if (!(obj instanceof StaticBean)) {
            obj = Mixin.createBean((Object[])new Object[]{obj, EsbFactory.creatStaticBean(true)});
        }
        ExpressionCompiler compiler = new ExpressionCompiler(expression, EsbFactory.getParserContext());
        return compiler.getReturnType();
    }

    public static ParserContext getParserContext() {
        ParserContext context = (ParserContext)JDSActionContext.getActionContext().getContext().get("ParserContext");
        if (context == null) {
            context = new ParserContext();
            List<? extends ServiceBean> serviceBeans = EsbBeanFactory.getInstance().getServiceBeanByFlowType(EsbFlowType.function);
            for (ServiceBean serviceBean : serviceBeans) {
                try {
                    Method[] methods;
                    Class clazz = ClassUtility.loadClass(serviceBean.getClazz());
                    for (Method method : methods = clazz.getDeclaredMethods()) {
                        if (!Modifier.isStatic(method.getModifiers())) continue;
                        context.addImport(method.getName().toLowerCase(), new MethodStub(method));
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            for (Class clazz : JSONClass) {
                context.addImport(clazz.getSimpleName(), clazz);
            }
            context.addImport("Math", Math.class);
            HashMap<String, DebugInterceptor> interceptors = new HashMap<String, DebugInterceptor>();
            interceptors.put("Debug", new DebugInterceptor());
            context.setInterceptors(interceptors);
            JDSActionContext.getActionContext().getContext().put("ParserContext", context);
        }
        return context;
    }

    public static <T> T par(String expression, Map context, Object source, Class<T> clazz) {
        Object o = null;
        StaticBean root = EsbFactory.creatStaticBean(false);
        root.setSource(source);
        HashMap<String, Object> myMacros = new HashMap<String, Object>();
        List<? extends ServiceBean> beans = EsbBeanFactory.getInstance().getServiceBeanByFlowType(EsbFlowType.localAction);
        for (ServiceBean serviceBean : beans) {
            myMacros.put(EsbKey + serviceBean.getId(), new EMacro(serviceBean));
        }
        Set contextKeySet = JDSActionContext.getActionContext().getContext().keySet();
        for (String contextKey : contextKeySet) {
            myMacros.put(contextKey, new CTXMacro(contextKey));
        }
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(myMacros);
        String parsedExpression = macroProcessor.parse(expression);
        ParserContext ctx = EsbFactory.getParserContext();
        ExpressionCompiler compiler = new ExpressionCompiler(parsedExpression, ctx);
        CompiledExpression s = compiler.compile();
        if (context == null || context.isEmpty()) {
            context = new HashMap();
        }
        if (clazz == null) {
            clazz = Object.class;
        }
        o = MVEL.executeExpression((Object)s, (Object)root, context, clazz);
        if (o != null) {
            try {
                Field[] fields;
                for (Field field : fields = o.getClass().getDeclaredFields()) {
                    Object object;
                    EsbRequest request;
                    EsbObj param = field.getAnnotation(EsbObj.class);
                    if (param != null) {
                        String expressionStr = param.id();
                        if ((expressionStr == null || expressionStr.equals("")) && EsbBeanFactory.getInstance().getDefaultServiceBean(field.getType()) != null) {
                            expressionStr = EsbBeanFactory.getInstance().getDefaultServiceBean(field.getType()).getId();
                        }
                        Object object2 = EsbFactory.par(EsbKey + expressionStr, field.getType());
                        field.set(o, object2);
                    }
                    Autowired autowired = field.getAnnotation(Autowired.class);
                    if (param != null) {
                        String expressionStr = param.id();
                        if ((expressionStr == null || expressionStr.equals("")) && EsbBeanFactory.getInstance().getDefaultServiceBean(field.getType()) != null) {
                            expressionStr = EsbBeanFactory.getInstance().getDefaultServiceBean(field.getType()).getId();
                        }
                        Object object3 = EsbFactory.par(EsbKey + expressionStr, field.getType());
                        field.set(o, object3);
                    }
                    if ((request = field.getAnnotation(EsbRequest.class)) == null || !field.getType().equals(String.class)) continue;
                    String expressionStr = request.expressionArr();
                    if (expressionStr != null && !expressionStr.equals("")) {
                        object = EsbFactory.par(EsbKey + expressionStr, field.getType());
                        field.set(o, object);
                        continue;
                    }
                    object = JDSActionContext.getActionContext().getParams(field.getName());
                    field.set(o, object);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return (T)o;
    }

    static void loadStaticAllData(boolean reload) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        JDSExpressionParserManager.loadStaticAllData(reload);
    }

    public static synchronized StaticBean creatStaticBean(boolean reload) {
        if (esbContext == null || reload) {
            Class iface = EsbFactory.getEsbContext();
            MethodInterceptor staticMethodInterceptor = new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] objects, MethodProxy proxy) {
                    String name = method.getName();
                    Object returnObject = null;
                    Map nameMap = JDSExpressionParserManager.getName2functionMap();
                    if (name.equals("setSource")) {
                        if (objects != null && objects.length == 1) {
                            JDSActionContext.getActionContext().getContext().put(EsbFactory.ESBMVELSOURCE, objects[0]);
                        }
                    } else if (name.equals("getSource")) {
                        returnObject = JDSActionContext.getActionContext().getContext().get(EsbFactory.ESBMVELSOURCE);
                    } else if (nameMap.containsKey(name)) {
                        if ((objects == null || objects.length == 0) && name.startsWith(EsbFactory.EsbKey)) {
                            returnObject = EsbFactory.getContextRootById(name);
                        } else {
                            Function function = (Function)nameMap.get(name);
                            Stack<Object> stack = new Stack<Object>();
                            for (int k = 0; k < objects.length; ++k) {
                                stack.push(objects[k]);
                            }
                            try {
                                function.run(stack);
                                returnObject = stack.pop();
                            }
                            catch (Throwable e) {
                                logger.error("ParseExpressionException:", e);
                                e.printStackTrace();
                            }
                        }
                    } else if (name.equals("ctx")) {
                        return JDSActionContext.getActionContext().getContext();
                    }
                    return returnObject;
                }
            };
            esbContext = Enhancer.create(Object.class, (Class[])new Class[]{iface, StaticBean.class}, (Callback)staticMethodInterceptor);
        }
        return (StaticBean)esbContext;
    }

    private static synchronized Class findClass(String expression) {
        Class clazz;
        if (expression.startsWith(EsbKey)) {
            expression = expression.substring(1);
        }
        if ((clazz = (Class<Object>)JDSExpressionParserManager.getExpressionTypeMap().get(expression)) == null) {
            Object obj = null;
            try {
                obj = MVEL.eval((String)expression);
                clazz = obj.getClass();
            }
            catch (Exception e) {
                clazz = Object.class;
            }
        }
        return clazz;
    }

    private static synchronized void addSignature(InterfaceMaker im, ExpressionTempBean bean) {
        Class clazz = (Class)JDSExpressionParserManager.getExpressionTypeMap().get(bean.getId());
        Function function = (Function)JDSExpressionParserManager.getName2functionMap().get(bean.getReturntype());
        if (clazz != null && function != null) {
            int k;
            Signature sig = null;
            List params = null;
            String expression = bean.getExpressionArr();
            if (expression != null) {
                params = ParseTools.parseMethodOrConstructor((char[])expression.toCharArray());
            }
            Class[] classs = new Class[function.getNumberOfParameters()];
            if (params == null || function.getNumberOfParameters() < params.size()) {
                logger.warn("[" + bean.getId() + "=" + bean.getExpressionArr() + "] in " + function.getClass() + " NumberOfParameters=" + function.getNumberOfParameters());
                return;
            }
            Type retuntype = TypeUtils.getType((String)clazz.getName());
            try {
                for (k = 0; k < params.size(); ++k) {
                    String param = new String((char[])params.get(k));
                    classs[k] = param.indexOf("(") > -1 ? EsbFactory.findClass(new String(ParseTools.subset((char[])param.toCharArray(), (int)0, (int)ArrayTools.findFirst((char)'(', (int)0, (int)param.length(), (char[])param.toCharArray())))) : EsbFactory.findClass(param);
                }
            }
            catch (Exception e) {
                logger.warn("[" + bean.getId() + "=" + bean.getExpressionArr() + "]" + e.getMessage());
            }
            if (function.getNumberOfParameters() > params.size()) {
                logger.warn("[" + bean.getId() + "=" + bean.getExpressionArr() + "] NumberOfParameters=" + function.getNumberOfParameters());
                for (k = params.size(); k < function.getNumberOfParameters(); ++k) {
                    classs[k] = Object.class;
                }
            }
            Type[] argumentTypes = TypeUtils.getTypes((Class[])classs);
            if (retuntype != null) {
                if (bean.getReturntype() == null || bean.getReturntype().equals("")) {
                    bean.setReturntype(bean.getId());
                }
                if (!signatureMap.containsValue(sig = new Signature(bean.getReturntype().trim(), retuntype, argumentTypes))) {
                    im.add(sig, null);
                    signatureMap.put(bean.getReturntype(), sig);
                }
                if (!bean.getId().contains(".")) {
                    Signature $sig;
                    Type[] nullargumentTypes = new Type[]{};
                    Signature getSig = new Signature("get$" + bean.getId(), retuntype, nullargumentTypes);
                    if (!signatureMap.containsValue(getSig)) {
                        im.add(getSig, null);
                        signatureMap.put("get$" + bean.getId(), getSig);
                    }
                    if (!signatureMap.containsValue($sig = new Signature(EsbKey + bean.getId(), retuntype, nullargumentTypes))) {
                        im.add($sig, null);
                        signatureMap.put(EsbKey + bean.getId(), getSig);
                    }
                }
            }
        }
    }

    public static synchronized Class getEsbContext() {
        if (contextClass == null) {
            InterfaceMaker im = new InterfaceMaker();
            EsbBeanFactory esbfactory = EsbBeanFactory.getInstance();
            List<? extends ServiceBean> expressionList = esbfactory.loadAllServiceBean();
            for (int i = 0; i < expressionList.size(); ++i) {
                ExpressionTempBean bean;
                if (!(expressionList.get(i) instanceof ExpressionTempBean) || (bean = (ExpressionTempBean)expressionList.get(i)) == null || bean.getDataType().equals(ContextType.Server)) continue;
                EsbFactory.addSignature(im, bean);
            }
            im.setClassLoader(Thread.currentThread().getContextClassLoader());
            contextClass = im.create();
        }
        return contextClass;
    }

    static synchronized Object getContext() {
        ActionContext ctx = ActionContext.getContext();
        Object esbContext = ctx.get("EsbContext");
        if (esbContext == null) {
            esbContext = EsbFactory.creatStaticBean(false);
            ctx.put("EsbContext", esbContext);
        }
        return esbContext;
    }

    public static Object getDefauleRoot() {
        return CacheManagerFactory.createCache("org", "staticCache");
    }

    static {
        init = false;
    }

    public static class EMacro
    implements Macro {
        public ServiceBean bean;

        public EMacro(ServiceBean bean) {
            this.bean = bean;
        }

        public String doMacro() {
            return this.bean.getExpression();
        }
    }
}

