/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esb.config.xml;

import com.ds.common.JDSException;
import com.ds.common.property.ConfigFactory;
import com.ds.common.property.XMLProperties;
import com.ds.config.JDSConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ServiceConfig {
    private String fileName = "expressiontemplet_config.xml";
    private static final Map<String, XMLProperties> propertiesMap = new HashMap<String, XMLProperties>();
    private static final Map<String, ServiceConfig> serverConfigMap = new HashMap<String, ServiceConfig>();
    private XMLProperties propertie;

    public static void clear() {
        propertiesMap.clear();
        serverConfigMap.clear();
    }

    public static ServiceConfig getServiceConfig(String configFileName) throws JDSException {
        ServiceConfig serviceConfig = serverConfigMap.get(configFileName);
        if (serviceConfig == null) {
            serviceConfig = new ServiceConfig(configFileName);
            serverConfigMap.put(configFileName, serviceConfig);
        }
        return serviceConfig;
    }

    XMLProperties getProperties() throws JDSException {
        this.propertie = propertiesMap.get(this.fileName);
        if (this.propertie == null) {
            File engineConfigFile = new File(JDSConfig.Config.configPath(), this.fileName);
            if (!engineConfigFile.exists()) {
                engineConfigFile = new File(JDSConfig.Config.publicConfigPath(), this.fileName);
            }
            if (!engineConfigFile.exists()) {
                String path = JDSConfig.getAbsolutePath(File.separator);
                if (path == null) {
                    path = "JDSHome" + File.separator + "config" + File.separator;
                }
                engineConfigFile = new File(path + this.fileName);
            }
            if (engineConfigFile.exists()) {
                this.propertie = ConfigFactory.getXML(engineConfigFile.getAbsolutePath());
                propertiesMap.put(this.fileName, this.propertie);
            } else {
                throw new JDSException("System error:   " + engineConfigFile.getAbsolutePath() + " not  exists! '" + 22);
            }
        }
        return this.propertie;
    }

    ServiceConfig(String fileName) throws JDSException {
        if (fileName != null) {
            this.fileName = fileName;
        }
        this.getProperties();
    }

    public String getValue(String name) {
        return this.propertie.getProperty(name);
    }

    public String[] getValues(String name) {
        return this.propertie.getProperties(name);
    }

    String getFileName() {
        return this.fileName;
    }

    void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

