/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esb.config.manager;

import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.esb.config.ContextType;
import com.ds.esb.config.EsbBeanType;
import com.ds.esb.config.TokenType;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.EsbBeanConfig;
import com.ds.esb.config.xml.ServiceConfig;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;

public class EsbBeanManager {
    private static final Log logger = LogFactory.getLog("esb", EsbBeanManager.class);
    private static final String configName = "esbbean_config.xml";
    private static final String userconfigName = "useresbbean_config.xml";
    private static final String configId = "configid";
    private static final String id = "id";
    private static final String esbtype = "esbtype";
    private static final String type = "type";
    private static final String tokenType = "tokenType";
    public static EsbBeanConfig esbBeanListBean;

    static EsbBeanConfig getEsbBeanList() {
        if (esbBeanListBean == null || esbBeanListBean.getReload().equals("true")) {
            esbBeanListBean = EsbBeanManager.newEsbBeanList();
        }
        return esbBeanListBean;
    }

    static EsbBeanConfig initSystemConfig() {
        EsbBeanConfig esbBeanListBean = new EsbBeanConfig();
        ServiceConfig config = null;
        try {
            config = ServiceConfig.getServiceConfig(configName);
            BeanMap esbBeanListBeanMap = BeanMap.create((Object)esbBeanListBean);
            for (String key : esbBeanListBeanMap.keySet()) {
                String[] esbbeanIds;
                Class clazz = esbBeanListBeanMap.getPropertyType(key);
                if (clazz.isAssignableFrom(String.class)) {
                    esbBeanListBeanMap.put((Object)key, (Object)config.getValue(key));
                    continue;
                }
                HashMap<String, EsbBean> esbBeanMap = new HashMap<String, EsbBean>();
                for (String esbBeanId : esbbeanIds = config.getValues(configId)) {
                    EsbBean eabBean = new EsbBean();
                    BeanMap beanmap = BeanMap.create((Object)eabBean);
                    for (String esbkey : beanmap.keySet()) {
                        String value = config.getValue(esbBeanId + "." + esbkey);
                        if (esbkey.equals(type)) {
                            if (value == null || value.equals("")) continue;
                            eabBean.setType(ContextType.fromType(value));
                            continue;
                        }
                        if (esbkey.equals(tokenType)) {
                            if (value == null || value.equals("")) continue;
                            eabBean.setTokenType(TokenType.fromType(value));
                            continue;
                        }
                        beanmap.put((Object)esbkey, (Object)value);
                    }
                    beanmap.put((Object)id, (Object)esbBeanId);
                    beanmap.put((Object)esbtype, (Object)EsbBeanType.System);
                    esbBeanMap.put(esbBeanId, eabBean);
                }
                esbBeanListBeanMap.put((Object)key, esbBeanMap);
            }
        }
        catch (JDSException e) {
            logger.warn(e.getMessage());
        }
        return esbBeanListBean;
    }

    static EsbBeanConfig fullUserConfig(EsbBeanConfig esbBeanListBean) throws JDSException {
        ServiceConfig userconfig = ServiceConfig.getServiceConfig(userconfigName);
        if (esbBeanListBean == null) {
            esbBeanListBean = new EsbBeanConfig();
        }
        BeanMap esbBeanListBeanMap = BeanMap.create((Object)esbBeanListBean);
        for (String key : esbBeanListBeanMap.keySet()) {
            String[] userEsbBeanIds;
            Class clazz = esbBeanListBeanMap.getPropertyType(key);
            if (clazz.isAssignableFrom(String.class)) {
                esbBeanListBeanMap.put((Object)key, (Object)userconfig.getValue(key));
                continue;
            }
            Map sysBeanMap = (Map)esbBeanListBeanMap.get((Object)key);
            if (userconfig == null) continue;
            for (String userEsbBeanId : userEsbBeanIds = userconfig.getValues(configId)) {
                EsbBean eabBean = (EsbBean)sysBeanMap.get(userEsbBeanId);
                if (eabBean == null) {
                    eabBean = new EsbBean();
                }
                if (eabBean.getEsbtype() != null && eabBean.getEsbtype().equals(EsbBeanType.System)) continue;
                BeanMap beanmap = BeanMap.create((Object)eabBean);
                for (String esbkey : beanmap.keySet()) {
                    String value = userconfig.getValue(userEsbBeanId + "." + esbkey);
                    if (esbkey.equals(esbtype)) {
                        if (value == null || value.equals("")) continue;
                        eabBean.setEsbtype(EsbBeanType.fromType(value));
                        continue;
                    }
                    if (esbkey.equals(type)) {
                        if (value == null || value.equals("")) continue;
                        eabBean.setType(ContextType.fromType(value));
                        continue;
                    }
                    if (esbkey.equals(tokenType)) {
                        if (value == null || value.equals("")) continue;
                        eabBean.setTokenType(TokenType.fromType(value));
                        continue;
                    }
                    beanmap.put((Object)esbkey, (Object)value);
                }
                beanmap.put((Object)id, (Object)userEsbBeanId);
                sysBeanMap.put(userEsbBeanId, eabBean);
            }
        }
        return esbBeanListBean;
    }

    private static EsbBeanConfig newEsbBeanList() {
        EsbBeanConfig esbBeanListBean = null;
        try {
            esbBeanListBean = EsbBeanManager.initSystemConfig();
            esbBeanListBean = EsbBeanManager.fullUserConfig(esbBeanListBean);
        }
        catch (JDSException e) {
            logger.error(e);
        }
        return esbBeanListBean;
    }
}

