/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esb.config.manager;

import com.ds.cluster.ServerNode;
import com.ds.common.CommonConfig;
import com.ds.common.expression.ExpressionParser;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.StringUtility;
import com.ds.enums.ServiceStatus;
import com.ds.esb.config.ContextType;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.esb.config.EsbBeanType;
import com.ds.esb.config.EsbConstructor;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.JDSBusException;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.EsbBeanConfig;
import com.ds.esb.config.manager.EsbBeanManager;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.JDSExpressionParserManager;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esb.config.manager.ServiceConfigManager;
import com.ds.esb.config.xml.ServiceConfig;
import com.ds.server.JDSServer;
import com.ds.server.SubSystem;
import com.ds.web.util.AnnotationUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsbBeanFactory {
    private static final Logger logger = LoggerFactory.getLogger(EsbBeanFactory.class);
    public Map<String, ServiceBean> nameMap = new LinkedHashMap<String, ServiceBean>();
    public Map<String, ServiceBean> idMap = new LinkedHashMap<String, ServiceBean>();
    public Map<String, ServiceConfigManager> managerMap = new LinkedHashMap<String, ServiceConfigManager>();
    public Map<String, List<? extends ServiceBean>> configListMap = new LinkedHashMap<String, List<? extends ServiceBean>>();
    private Map<String, List<? extends ServiceBean>> esbBeanKeyMap = new LinkedHashMap<String, List<? extends ServiceBean>>();
    public List<ServiceBean> expressionTempBeanList = new ArrayList<ServiceBean>();
    public List<EsbBean> esbBeanList = new ArrayList<EsbBean>();
    public EsbBeanConfig esbBeanConfig;
    private static Map<String, Class<?>> allClass = new ConcurrentHashMap();
    private static EsbBeanFactory esbBeanFantory;
    public static final String THREAD_LOCK = "Thread Lock";
    private Map<Class, ServiceBean> classMap = new HashMap<Class, ServiceBean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EsbBeanFactory getInstance() {
        if (esbBeanFantory != null) return esbBeanFantory;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (esbBeanFantory != null) return esbBeanFantory;
            esbBeanFantory = new EsbBeanFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return esbBeanFantory;
        }
    }

    EsbBeanFactory() {
        this.esbBeanConfig = EsbBeanManager.getEsbBeanList();
        this.init();
    }

    public synchronized Set<Class<?>> dyReLoad(String esbkey) {
        if (esbkey == null) {
            esbkey = "local";
        }
        LinkedHashSet<Class<?>> classes = new LinkedHashSet();
        Map<String, EsbBean> esbBeanMap = this.esbBeanConfig.getEsbBeanMap();
        EsbBean esbBean = esbBeanMap.get(esbkey);
        if (esbBean != null) {
            classes = this.initEsbBean(esbkey, esbBean);
        }
        Set<String> keySet = ClassUtility.getDynClassMap().keySet();
        for (String key : keySet) {
            classes.add(ClassUtility.getDynClassMap().get(key));
        }
        return classes;
    }

    public synchronized void reLoad() {
        this.nameMap.clear();
        this.idMap.clear();
        this.idMap.clear();
        this.configListMap.clear();
        this.esbBeanKeyMap.clear();
        this.expressionTempBeanList.clear();
        this.classMap.clear();
        allClass.clear();
        CommonConfig.reLoad();
        ServiceConfig.clear();
        this.esbBeanConfig = EsbBeanManager.getEsbBeanList();
        this.init();
    }

    private EsbBean getEsbBeanByUrl(String url) {
        for (EsbBean bean : this.esbBeanList) {
            if (bean == null || bean.getServerUrl() == null || !url.startsWith(bean.getServerUrl())) continue;
            return bean;
        }
        return null;
    }

    public EsbBean getTopEsbBeanById(String id) {
        for (EsbBean bean : this.esbBeanList) {
            if (bean.getId() == null || !bean.getId().equals(id)) continue;
            return bean;
        }
        return null;
    }

    public void registerService(String systemCode, ServiceBean bean) {
        SubSystem system;
        ServerNode serverNode = JDSServer.getClusterClient().getServerNodeById(systemCode);
        if (serverNode != null && (system = JDSServer.getClusterClient().getSystem(serverNode.getId())) != null) {
            EsbBean esbBean = this.getEsbBeanByUrl(serverNode.getUrl());
            if (esbBean == null) {
                esbBean = new EsbBean(system);
            }
            this.addBean(esbBean, bean);
        }
    }

    public void registerService(Class clazz) {
        ExpressionTempBean defaultServiceBean = this.getDefaultServiceBean(clazz);
        if (defaultServiceBean == null) {
            ExpressionTempBean mvcBean = new ExpressionTempBean();
            mvcBean.setId(clazz.getSimpleName());
            mvcBean.setClazz(clazz.getName());
        }
    }

    public ExpressionTempBean getDefaultServiceBean(Class clazz) {
        ExpressionTempBean bean = (ExpressionTempBean)this.classMap.get(clazz);
        List<? extends ServiceBean> beans = this.getServiceBeanList(clazz);
        if (beans.size() > 0) {
            bean = (ExpressionTempBean)beans.get(0);
            this.classMap.put(clazz, beans.get(0));
        }
        return bean;
    }

    public List<? extends ServiceBean> getServiceBeanList(Class clazz) {
        ArrayList<ExpressionTempBean> beans = new ArrayList<ExpressionTempBean>();
        for (ServiceBean bean : this.expressionTempBeanList) {
            ExpressionTempBean expressionTempBean = (ExpressionTempBean)bean;
            if (!expressionTempBean.getStatus().equals(ServiceStatus.normal)) continue;
            Class innerClazz = null;
            try {
                innerClazz = ClassUtility.loadClass(expressionTempBean.getClazz());
                if (!clazz.getName().equals(innerClazz.getName()) && !clazz.isAssignableFrom(innerClazz)) continue;
                beans.add(expressionTempBean);
            }
            catch (ClassNotFoundException e) {
                ((ExpressionTempBean)bean).setStatus(ServiceStatus.unavailable);
                logger.error("bean " + bean.getId() + "(" + bean.getClazz() + "): class not found ");
            }
        }
        return beans;
    }

    void addBean(EsbBean esbbean, ServiceBean bean) {
        if (bean.getClazz() != null) {
            if (this.idMap.containsKey(bean.getId())) {
                ServiceBean oldBean = this.idMap.get(bean.getId());
                if (oldBean != null && (bean.getVersion() > oldBean.getVersion() || esbbean.getEsbtype().equals(EsbBeanType.Local))) {
                    this.expressionTempBeanList.remove(this.idMap.get(bean.getId()));
                    this.expressionTempBeanList.add(bean);
                    this.nameMap.put(bean.getName(), bean);
                    this.idMap.put(bean.getId(), bean);
                    Class clazz = null;
                    try {
                        clazz = ClassUtility.loadClass(bean.getClazz());
                        if (bean instanceof ExpressionTempBean) {
                            this.classMap.put(clazz, (ExpressionTempBean)bean);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("ExpressionTempManager addBean Error:", (Throwable)e);
                    }
                }
            } else {
                this.expressionTempBeanList.add(bean);
                this.nameMap.put(bean.getName(), bean);
                this.idMap.put(bean.getId(), bean);
            }
        }
    }

    public Map<EsbFlowType, List<? extends ServiceBean>> getAllServiceBeanByType() {
        EsbFlowType[] types;
        HashMap<EsbFlowType, List<? extends ServiceBean>> typeListMap = new HashMap<EsbFlowType, List<? extends ServiceBean>>();
        for (EsbFlowType type : types = EsbFlowType.values()) {
            typeListMap.put(type, this.getServiceBeanByFlowType(type));
        }
        return typeListMap;
    }

    public List<? extends ServiceBean> getServiceBeanByFlowType(EsbFlowType ... flowType) {
        List<? extends ServiceBean> beans = this.loadAllServiceBean();
        List<EsbFlowType> flowTypes = Arrays.asList(flowType);
        ArrayList<ExpressionTempBean> fitleBeans = new ArrayList<ExpressionTempBean>();
        for (ServiceBean serviceBean : beans) {
            if (serviceBean.getFlowType() == null || !flowTypes.contains(serviceBean.getFlowType()) || !(serviceBean instanceof ExpressionTempBean)) continue;
            fitleBeans.add((ExpressionTempBean)serviceBean);
        }
        return fitleBeans;
    }

    Set<Class<?>> initEsbBean(String key, EsbBean esbBean) {
        Set<Object> classes = new LinkedHashSet();
        ServiceConfigManager expressionTemManager = esbBean.getManager();
        try {
            classes = expressionTemManager.init();
            if (classes != null) {
                for (Class clazz : classes) {
                    if (clazz == null) continue;
                    allClass.put(clazz.getName(), clazz);
                }
            } else {
                logger.warn("ExpressionTempManager [" + esbBean.getId() + "]Init Error: calsses is null, path[" + esbBean.getPath() + "]");
            }
        }
        catch (JDSBusException e) {
            logger.error("ExpressionTempManager Init Error:", (Throwable)e);
            e.printStackTrace();
        }
        this.managerMap.put(key, expressionTemManager);
        this.configListMap.put(esbBean.getPath(), expressionTemManager.loadAllService());
        this.esbBeanKeyMap.put(key, expressionTemManager.loadAllService());
        List<ServiceBean> esbList = expressionTemManager.loadAllService();
        for (ServiceBean bean : esbList) {
            this.addBean(esbBean, bean);
        }
        for (ServiceBean bean : esbList) {
            if (!(bean instanceof ExpressionTempBean)) continue;
            try {
                if (bean.getClazz() != null) {
                    Constructor<?>[] constructors;
                    Class clazz = ClassUtility.loadClass(bean.getClazz());
                    for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                        Parameter[] parameters = constructor.getParameters();
                        if (bean.getDataType() != null && bean.getDataType().equals(ContextType.Server)) {
                            ((ExpressionTempBean)bean).setFlowType(EsbFlowType.remoteAction);
                        }
                        if (parameters.length <= 0 || constructor.getAnnotation(EsbConstructor.class) == null) continue;
                        StringBuffer strMethod = new StringBuffer();
                        strMethod.append(clazz.getSimpleName() + "(");
                        for (Parameter param : parameters) {
                            ExpressionTempBean paramBean = this.getDefaultServiceBean(param.getType());
                            if (paramBean != null) {
                                strMethod.append("$" + paramBean.getExpressionArr() + ",");
                                continue;
                            }
                            strMethod.append("null,");
                        }
                        strMethod.deleteCharAt(strMethod.length() - 1);
                        strMethod.append(")");
                        ((ExpressionTempBean)bean).setExpressionArr(strMethod.toString());
                    }
                    JDSExpressionParserManager.fullBean((ExpressionTempBean)bean);
                    continue;
                }
                logger.warn("bean " + bean.getId() + ": class in null");
            }
            catch (ClassNotFoundException e) {
                logger.warn("bean " + bean.getId() + "(" + bean.getClazz() + "): class not found ");
            }
        }
        return classes;
    }

    public static Class<?> addClassCache(String className, Class<?> clazz) {
        allClass.put(className, clazz);
        return clazz;
    }

    public static Class<?> findClass(String className) {
        Class<?> clazz = allClass.get(className);
        return clazz;
    }

    public Map<String, Class<?>> getAllClass() {
        allClass.putAll(ClassUtility.getDynClassMap());
        return allClass;
    }

    public Set<Class<?>> getAllClassBykey(String esbkey) {
        Map<String, EsbBean> esbBeanMap;
        EsbBean esbBean;
        Set<Class<?>> classes = new LinkedHashSet();
        if (esbkey == null) {
            esbkey = "local";
        }
        if ((esbBean = (esbBeanMap = this.esbBeanConfig.getEsbBeanMap()).get(esbkey)) != null) {
            ServiceConfigManager expressionTemManager = esbBean.getManager();
            try {
                classes = expressionTemManager.init();
            }
            catch (JDSBusException e) {
                logger.error("ExpressionTempManager Init Error:", (Throwable)e);
                e.printStackTrace();
            }
        }
        return classes;
    }

    Map<String, ServiceConfigManager> getManagerMap() {
        return this.managerMap;
    }

    Map<String, ServiceBean> getNameMap() {
        return this.nameMap;
    }

    public List<? extends ServiceBean> getAllServiceBeanByEsbKey(String key) {
        return this.esbBeanKeyMap.get(key);
    }

    public List<? extends ServiceBean> getServiceBeanByName(String serviceName) {
        Set<String> keySet = this.configListMap.keySet();
        ArrayList<ServiceBean> beans = new ArrayList<ServiceBean>();
        for (String key : keySet) {
            ServiceBean bean = this.getServiceBeanInEsb(key, serviceName);
            if (bean == null) continue;
            beans.add(bean);
        }
        return beans;
    }

    private ServiceBean getServiceBeanInEsb(String esbkey, String serviceName) {
        List<? extends ServiceBean> beans = this.configListMap.get(esbkey);
        if (beans != null) {
            for (ServiceBean serviceBean : beans) {
                if (!serviceBean.getId().equals(serviceName)) continue;
                return serviceBean;
            }
        }
        return null;
    }

    public EsbBeanConfig getEsbBeanConfig() {
        return this.esbBeanConfig;
    }

    public List<? extends ServiceBean> loadAllServiceBean() {
        return this.expressionTempBeanList;
    }

    public Map<String, List<? extends ServiceBean>> getConfigListMap() {
        return this.configListMap;
    }

    public void init() {
        Map<String, EsbBean> esbBeanMap = this.esbBeanConfig.getEsbBeanMap();
        for (String key : esbBeanMap.keySet()) {
            EsbBean esbBean = esbBeanMap.get(key);
            this.initEsbBean(key, esbBean);
            this.esbBeanList.add(esbBean);
        }
    }

    public ServiceBean getEsbBeanById(String objId) {
        EsbBeanFactory factory = EsbBeanFactory.getInstance();
        if (objId.startsWith("$")) {
            objId = objId.substring(1);
        }
        ExpressionTempBean bean = (ExpressionTempBean)factory.getIdMap().get(objId);
        if (factory.getEsbBeanConfig().getReload().equals("true")) {
            ExpressionParser parser = JDSExpressionParserManager.getExpressionParser(null);
            try {
                JDSExpressionParserManager.loadStaticAllData(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bean.getPath() != null) {
                File file = new File(bean.getPath());
                if (bean.getCreatTime() == null || file.lastModified() > bean.getCreatTime()) {
                    String className = bean.getClazz();
                    try {
                        Class clazz = ClassUtility.loadClass(className);
                        EsbBeanAnnotation annotation = AnnotationUtil.getClassAnnotation(clazz, EsbBeanAnnotation.class);
                        bean.setExpressionArr(annotation.expressionArr());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return bean;
    }

    public static String formatFilePath(String path) {
        path = !"/".equals(File.separator) ? StringUtility.replace(path, "/", File.separator) : StringUtility.replace(path, "\\", File.separator);
        return path;
    }

    public List<EsbBean> getLocalBeanList() {
        ArrayList<EsbBean> localBeans = new ArrayList<EsbBean>();
        for (EsbBean esbBean : this.esbBeanList) {
            if (esbBean.getServerUrl() != null && !esbBean.getServerUrl().equals("")) continue;
            esbBean.setEsbtype(EsbBeanType.Local);
            localBeans.add(esbBean);
        }
        return localBeans;
    }

    public List<EsbBean> getRemoveBeanList() {
        ArrayList<EsbBean> localBeans = new ArrayList<EsbBean>();
        for (EsbBean esbBean : this.esbBeanList) {
            if (esbBean.getServerUrl() == null || esbBean.getServerUrl().equals("")) continue;
            if (esbBean.getEsbtype().equals(EsbBeanType.Local)) {
                esbBean.setEsbtype(EsbBeanType.Remote);
            }
            localBeans.add(esbBean);
        }
        return localBeans;
    }

    public List<EsbBean> getSystemBeanList() {
        ArrayList<EsbBean> localBeans = new ArrayList<EsbBean>();
        for (EsbBean esbBean : this.esbBeanList) {
            if (!esbBean.getEsbtype().equals(EsbBeanType.System)) continue;
            localBeans.add(esbBean);
        }
        return localBeans;
    }

    public List<EsbBean> getEsbBeanList() {
        return this.esbBeanList;
    }

    public void setEsbBeanList(List<EsbBean> esbBeanList) {
        this.esbBeanList = esbBeanList;
    }

    public Map<String, ServiceBean> getIdMap() {
        return this.idMap;
    }
}

