/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esb.config.manager;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.esb.config.ContextType;
import com.ds.esb.config.EsbBeanType;
import com.ds.esb.config.TokenType;
import com.ds.esb.config.annotation.ExpressionTempAnnotationProxy;
import com.ds.esb.config.manager.ServiceConfigManager;
import com.ds.esb.config.xml.ExpressionTempXmlProxy;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.server.OrgManagerFactory;
import com.ds.server.SubSystem;

public class EsbBean {
    protected static final transient Log log = LogFactory.getLog("esb", EsbBean.class);
    private String id;
    private String cnname;
    private TokenType tokenType = TokenType.guest;
    private ContextType type;
    private EsbBeanType esbtype = EsbBeanType.Local;
    private String vfsPath;
    private String desc;
    private String path;
    private String username;
    private String driver;
    private String connectionProvider;
    private String maxconnection = "2000";
    private String minconnection = "200";
    private String timeout = "60000";
    private String userexpression;
    private String password;
    private String serverUrl;
    private String serverKey;
    private String expressionTemManager;
    private String formClassManager;
    private ServiceConfigManager manager;

    public EsbBean() {
    }

    public EsbBean(SubSystem system) {
        this.id = system.getEnname();
        this.cnname = system.getName();
        this.tokenType = system.getTokenType();
        this.esbtype = EsbBeanType.Cluster;
        this.serverUrl = system.getUrl();
        this.vfsPath = system.getVfsPath();
        this.serverKey = system.getEnname();
        this.type = ContextType.Server;
        this.path = system.getUrl();
        this.vfsPath = system.getVfsPath();
        try {
            Person person = OrgManagerFactory.getOrgManager(system.getConfigname()).getPersonByID(system.getAdminId());
            this.username = person.getName();
        }
        catch (PersonNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getVfsPath() {
        return this.vfsPath;
    }

    public void setVfsPath(String vfsPath) {
        this.vfsPath = vfsPath;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(String connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public String getMaxconnection() {
        return this.maxconnection;
    }

    public void setMaxconnection(String maxconnection) {
        this.maxconnection = maxconnection;
    }

    public String getMinconnection() {
        return this.minconnection;
    }

    public void setMinconnection(String minconnection) {
        this.minconnection = minconnection;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getUserexpression() {
        return this.userexpression;
    }

    public void setUserexpression(String userexpression) {
        this.userexpression = userexpression;
    }

    public void setManager(ServiceConfigManager manager) {
        this.manager = manager;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public String getCnname() {
        return this.cnname;
    }

    public void setCnname(String cnname) {
        this.cnname = cnname;
    }

    public String getExpressionTemManager() {
        return this.expressionTemManager;
    }

    public void setExpressionTemManager(String expressionTemManager) {
        this.expressionTemManager = expressionTemManager;
    }

    public String getFormClassManager() {
        return this.formClassManager;
    }

    public void setFormClassManager(String formClassManager) {
        this.formClassManager = formClassManager;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ContextType getType() {
        return this.type;
    }

    public void setType(ContextType type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EsbBeanType getEsbtype() {
        return this.esbtype;
    }

    public void setEsbtype(EsbBeanType esbtype) {
        this.esbtype = esbtype;
    }

    public ServiceConfigManager getManager() {
        if (this.manager == null) {
            try {
                if (this.getExpressionTemManager() != null) {
                    Class managerClass = ClassUtility.loadClass(this.getExpressionTemManager());
                    this.manager = (ServiceConfigManager)managerClass.getConstructor(EsbBean.class).newInstance(this);
                } else {
                    this.manager = this.getPath() != null && this.getPath().trim().endsWith("xml") ? new ExpressionTempXmlProxy(this) : new ExpressionTempAnnotationProxy(this);
                }
            }
            catch (Exception e) {
                log.error("ExpressionTempManager Reflect Construct failed!!!!", e);
                e.printStackTrace();
            }
        }
        return this.manager;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public void setServerKey(String serverKey) {
        this.serverKey = serverKey;
    }
}

