/*
 * Decompiled with CFR 0.152.
 */
package com.ds.config;

import com.ds.common.util.ClassUtility;
import com.ds.common.util.StringUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;

public class JDSUtil {
    static final String[] tpath = new String[]{"bin", "lib", "classes"};

    public static String getJdsPath() throws MalformedURLException, IOException {
        return JDSUtil.getJdsPath(null);
    }

    public static String getJdsPath(Class clazz) throws MalformedURLException, IOException {
        if (clazz == null) {
            clazz = JDSUtil.getDefaultClazz();
        }
        String runningURL = new URL(clazz.getProtectionDomain().getCodeSource().getLocation(), ".").openConnection().getPermission().getName();
        return runningURL;
    }

    private static Class getDefaultClazz() {
        Class<JDSUtil> clazz = null;
        try {
            clazz = ClassUtility.loadClass("com.ds.JDSInit");
        }
        catch (ClassNotFoundException e) {
            clazz = JDSUtil.class;
        }
        return clazz;
    }

    public static String getJdsRealPath() throws MalformedURLException, IOException {
        return JDSUtil.getJdsRealPath(null);
    }

    public static String getRootPath(String realPath) throws MalformedURLException, IOException {
        for (String path : tpath) {
            realPath = StringUtility.replace(realPath, "/" + path + "/", "/");
            realPath = StringUtility.replace(realPath, "\\" + path + "\\", "\\");
        }
        return realPath;
    }

    public static String getJdsRealPath(Class clazz) throws MalformedURLException, IOException {
        if (clazz == null) {
            clazz = JDSUtil.getDefaultClazz();
        }
        String realPath = JDSUtil.getJdsPath(clazz);
        realPath = JDSUtil.getRootPath(realPath);
        return realPath;
    }

    public static Color String2Color(String str) {
        if (str == null || "".equals(str)) {
            return Color.BLACK;
        }
        int i = Integer.parseInt(str, 16);
        return new Color(i);
    }

    public static ImageIcon zoomIcon(ImageIcon icon, Dimension size) {
        if (icon != null) {
            try {
                Image menuImage = icon.getImage();
                menuImage = menuImage.getScaledInstance(size.width, size.height, 1);
                icon.setImage(menuImage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return icon;
    }

    public static ImageIcon getIconImag(String icon) {
        URL imgUrl = null;
        try {
            imgUrl = new URL(icon);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ImageIcon imageIcon = new ImageIcon(imgUrl);
        return imageIcon;
    }

    public static Image getThumb(String thumb) {
        URL imgUrl = null;
        try {
            imgUrl = new URL(thumb);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ImageIcon imageIcon = new ImageIcon(imgUrl);
        return imageIcon.getImage();
    }
}

