/*
 * Decompiled with CFR 0.152.
 */
package com.ds.config;

import com.ds.common.property.ConfigFactory;
import com.ds.common.property.Properties;
import com.ds.common.property.XMLProperties;
import com.ds.common.util.ClassUtility;
import com.ds.config.UserBean;
import com.ds.server.eumus.ConfigCode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;

public class JDSConfig {
    private static final String CONFIG_FILENAME = "engine_config.xml";
    private static final String INIT_FILENAME = "jds_init.properties";
    private static final String INIT_CLIENTFILENAME = "jdsclient_init.properties";
    public static final String JDSHomeName = "JDSHome";
    private static String jdsHome;
    private static XMLProperties properties;
    public static final String THREAD_LOCK = "Thread Lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getServerHome() {
        File rootfile = new File(JDSConfig.getAbsolutePath("", null));
        if (jdsHome != null) return jdsHome;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            try {
                String mqhome;
                Properties props;
                jdsHome = System.getProperty(JDSHomeName);
                if (jdsHome == null) {
                    props = new Properties();
                    if (ClassUtility.loadResource(INIT_FILENAME) != null) {
                        props.load(ClassUtility.loadResource(INIT_FILENAME));
                        jdsHome = props.getProperty(JDSHomeName);
                    }
                    if (jdsHome != null) {
                        System.out.println(" JDSHome[ System.property] path='" + jdsHome + "'");
                    }
                }
                if (jdsHome == null) {
                    props = new Properties();
                    if (ClassUtility.loadResource(INIT_CLIENTFILENAME) != null) {
                        props.load(ClassUtility.loadResource(INIT_CLIENTFILENAME));
                        jdsHome = props.getProperty(JDSHomeName);
                    }
                    if (jdsHome != null) {
                        System.out.println("  JDSHome[ jdsclient_init.properties]  path='" + jdsHome + "'");
                    }
                }
                if (jdsHome == null && (mqhome = System.getProperty("activemq.home")) != null && !mqhome.equals("") && (jdsHome = mqhome + File.separator + JDSHomeName) != null) {
                    System.out.println("  JDSHome[activemq.home]  path='" + jdsHome + "'");
                }
                if (jdsHome == null) {
                    File jdshomefile = new File(rootfile, JDSHomeName);
                    if (!jdshomefile.exists()) {
                        while (jdshomefile != null) {
                            System.out.println("  JDSHome[" + jdshomefile.getAbsolutePath() + "] loop path= " + jdshomefile.getAbsolutePath());
                            File homeFile = new File(jdshomefile, JDSHomeName);
                            if (homeFile.exists()) {
                                jdshomefile = homeFile;
                                break;
                            }
                            jdshomefile = jdshomefile.getParentFile();
                        }
                    }
                    if (jdshomefile == null) {
                        jdshomefile = new File(rootfile, JDSHomeName);
                    }
                    if (jdshomefile == null || !jdshomefile.exists()) {
                        jdshomefile.mkdirs();
                        System.out.println("  JDSHome[ ] error " + jdshomefile.getAbsolutePath());
                    }
                    jdsHome = jdshomefile.getAbsolutePath();
                }
            }
            catch (IOException ioe) {
                jdsHome = JDSConfig.getAbsolutePath(".." + File.separator + ".." + File.separator + "..", new JDSConfig().getClass()) + ".." + File.separator + JDSHomeName;
            }
            System.out.println("JDSHome path='" + jdsHome + "'");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jdsHome;
        }
    }

    public static ConfigCode getConfigName() {
        ConfigCode currSystemCode = UserBean.getInstance().getConfigName();
        return currSystemCode;
    }

    public void reLoad() {
        properties = null;
        this.init();
    }

    public static String getValue(String name) {
        JDSConfig.init();
        if (properties != null) {
            return properties.getProperty(name);
        }
        return null;
    }

    public static String[] getValues(String name) {
        JDSConfig.init();
        if (properties != null) {
            return properties.getProperties(name);
        }
        return new String[0];
    }

    public static void setValue(String name, String value) {
        JDSConfig.init();
        if (properties != null) {
            properties.setProperty(name, value);
        }
    }

    public static String[] getChildrenProperties(String name) {
        JDSConfig.init();
        if (properties != null) {
            return properties.getChildrenProperties(name);
        }
        return new String[0];
    }

    private static void init() {
        if (properties == null) {
            File engineConfigFile = new File(Config.configPath(), CONFIG_FILENAME);
            if (!engineConfigFile.exists()) {
                engineConfigFile = new File(Config.publicConfigPath(), CONFIG_FILENAME);
            }
            if (!engineConfigFile.exists()) {
                String path = JDSConfig.getAbsolutePath(File.separator);
                engineConfigFile = new File(path + CONFIG_FILENAME);
            }
            properties = ConfigFactory.getXML(engineConfigFile.getAbsolutePath());
        }
    }

    public static String getJDSHomeAbsolutePath(String url) {
        return JDSConfig.getAbsolutePath(".." + File.separator + "..") + url;
    }

    public static String getAbsoluteLibPath() {
        return JDSConfig.getAbsolutePath(".." + File.separator + "lib").substring(1);
    }

    public static String getAbsolutePath(String relativePath) {
        return JDSConfig.getAbsolutePath(relativePath, null);
    }

    public static String getAbsolutePath(String relativePath, Class classzz) {
        String classPath;
        block18: {
            classPath = "";
            if (classzz == null) {
                try {
                    classzz = ClassUtility.loadClass("com.ds.JDSInit");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    classzz = JDSConfig.class;
                }
            } else {
                classzz = JDSConfig.class;
            }
            try {
                Properties props = new Properties();
                InputStream in = ClassUtility.loadResource(INIT_FILENAME);
                if (in != null) {
                    props.load(in);
                    classPath = props.getProperty("classPath");
                }
                if (classPath != null && !classPath.trim().equals("")) break block18;
                URL url = Thread.currentThread().getContextClassLoader().getResource(relativePath);
                if (url == null) {
                    try {
                        if (classzz.getResource(relativePath) != null && classzz.getResource(relativePath).toURI() != null) {
                            classPath = classzz.getResource(relativePath).toURI().getPath();
                        } else if (Thread.currentThread().getContextClassLoader().getResource(relativePath) != null) {
                            classPath = Thread.currentThread().getContextClassLoader().getResource(relativePath).getPath();
                        }
                        break block18;
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        classPath = Thread.currentThread().getContextClassLoader().getResource(relativePath).getPath();
                    }
                    break block18;
                }
                try {
                    classPath = url.toURI().getPath();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    classPath = url.getPath();
                }
            }
            catch (IOException ioe) {
                System.out.println("Fail to load JDS initial file jds_init.properties");
                ioe.printStackTrace();
                try {
                    classPath = classzz.getResource(relativePath).toURI().getPath();
                }
                catch (URISyntaxException e) {
                    classPath = Thread.currentThread().getContextClassLoader().getResource(relativePath).getPath();
                }
            }
        }
        if (classPath == null) {
            classPath = File.separator;
        }
        return classPath;
    }

    public static void main(String[] args) {
        File engineConfigFile = new File("E:");
        System.out.println(engineConfigFile.getParentFile());
    }

    public static class Config {
        public static File rootServerHome() {
            String serverHomeStr = JDSConfig.getServerHome();
            if (serverHomeStr == null) {
                serverHomeStr = JDSConfig.JDSHomeName;
            }
            File serverHome = new File(serverHomeStr);
            return serverHome;
        }

        public static File publicConfigPath() {
            File configPath = new File(Config.rootServerHome().getAbsoluteFile() + File.separator + "config");
            if (!configPath.exists() || !configPath.isDirectory()) {
                configPath.mkdirs();
                System.out.println(" Config path '" + configPath.getAbsolutePath() + "' does not exists!");
            }
            return configPath;
        }

        public static File applicationHome() {
            File jdsHome = Config.rootServerHome();
            File applicationHome = new File(jdsHome.getAbsoluteFile() + File.separator + "application");
            if (!applicationHome.exists() || !applicationHome.isDirectory()) {
                System.out.println("Application home '" + applicationHome.getAbsolutePath() + "' does not exits!");
            }
            return applicationHome;
        }

        public static File sourcePath() {
            File sourcePath = new File(Config.currServerHome().getAbsoluteFile() + File.separator + "classes" + File.separator);
            if (!sourcePath.exists() || !sourcePath.isDirectory()) {
                sourcePath.mkdirs();
            }
            return sourcePath;
        }

        public static File currServerHome() {
            File serverHome = new File(Config.applicationHome().getAbsolutePath() + File.separator + JDSConfig.getConfigName().getType());
            if (!serverHome.exists() || !serverHome.isDirectory()) {
                System.out.println("JDSHome '" + serverHome.getAbsolutePath() + "' does not exists!");
            }
            return serverHome;
        }

        public static File configPath() {
            File configPath = new File(Config.currServerHome().getAbsoluteFile() + File.separator + "config");
            if (!configPath.exists() || !configPath.isDirectory()) {
                configPath.mkdirs();
            }
            return configPath;
        }

        public static File libPath() {
            File libPath = new File(Config.currServerHome().getAbsoluteFile() + File.separator + "lib");
            if (!libPath.exists() || !libPath.isDirectory()) {
                libPath.mkdirs();
            }
            return libPath;
        }

        public static File dataPath() {
            return new File(Config.currServerHome().getAbsoluteFile() + File.separator + "data");
        }

        public static File tempPath() {
            return new File(Config.currServerHome().getAbsoluteFile() + File.separator + "temp");
        }

        public static boolean connectionProfile() {
            try {
                return new Boolean(JDSConfig.getValue("connectionProfile"));
            }
            catch (Exception e) {
                return false;
            }
        }

        public static boolean startAdminThread() {
            try {
                return new Boolean(JDSConfig.getValue("admin.StartAdminThread"));
            }
            catch (Exception e) {
                return false;
            }
        }

        public static boolean singleLogin() {
            try {
                return new Boolean(JDSConfig.getValue("singleLogin"));
            }
            catch (Exception e) {
                return false;
            }
        }

        public static InetAddress adminAddress() {
            try {
                return InetAddress.getByName(JDSConfig.getValue("admin.host"));
            }
            catch (Exception e) {
                try {
                    return InetAddress.getLocalHost();
                }
                catch (UnknownHostException uhe) {
                    return null;
                }
            }
        }

        public static int adminPort() {
            try {
                return Integer.parseInt(JDSConfig.getValue("admin.port"));
            }
            catch (Exception e) {
                return 10523;
            }
        }

        public static String adminKey() {
            String adminKey = JDSConfig.getValue("admin.key");
            if (adminKey == null) {
                adminKey = "NA";
            }
            return adminKey;
        }

        public static boolean dumpCache() {
            try {
                return new Boolean(JDSConfig.getValue("server.dumpCache"));
            }
            catch (Exception e) {
                return true;
            }
        }

        public static String cacheDbUser() {
            String cacheDbUser = JDSConfig.getValue("server.cacheDbUser");
            if (cacheDbUser == null) {
                cacheDbUser = "sa";
            }
            return cacheDbUser;
        }

        public static String cacheDbPassword() {
            String cacheDbPassword = JDSConfig.getValue("server.cacheDbPassword");
            if (cacheDbPassword == null) {
                cacheDbPassword = "";
            }
            return cacheDbPassword;
        }

        public static String cacheDbURL() {
            String cacheDbURL = JDSConfig.getValue("server.cacheDbURL");
            if (cacheDbURL == null) {
                cacheDbURL = "jdbc:hsqldb:hsql://localhost";
            }
            return cacheDbURL;
        }

        public static String cacheDbServerProps() {
            String cacheDbServerProps = JDSConfig.getValue("server.cacheDbServerProps");
            if (cacheDbServerProps == null) {
                try {
                    cacheDbServerProps = "database.0=" + new File(Config.dataPath().getAbsoluteFile() + File.separator + "cache").toURL();
                }
                catch (MalformedURLException mue) {
                    System.out.print(mue);
                }
            }
            return cacheDbServerProps;
        }
    }
}

